% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varEstToCov.R
\name{varEstToCov}
\alias{varEstToCov}
\title{Covariance Estimation}
\usage{
varEstToCov(varEstA, varEstB = varEstA, varA, varB = varA,
  jkSumMultiplier)
}
\arguments{
\item{varEstA}{a list of two \code{data.frame}s returned by a function after 
the \code{returnVarEstInputs} argument was turned on.
The statistic named in the \code{varA} argument must be
present in each \code{data.frame}.}

\item{varEstB}{a list of two \code{data.frame}s returned by a function after 
the \code{returnVarEstInputs} argument was turned on.
The statistic named in the \code{varA} argument must be
present in each \code{data.frame}. When the same as 
\code{varEstA}, the covariance is within one result.}

\item{varA}{a character that names the statistic in the \code{varEstA}
argument for which a covariance is required}

\item{varB}{a character that names the statistic in the \code{varEstB}
argument for which a covariance is required}

\item{jkSumMultiplier}{when the jackknife variance estimation method---or
balanced repeated replication (BRR) 
method---multiplies the final jackknife variance estimate by a value, 
set \code{jkSumMultiplier} to that value.
For an \code{edsurvey.data.frame}, or
a \code{light.edsurvey.data.frame},
the recommended value can be recovered with
\code{EdSurvey::getAttributes(}\code{myData,} \code{"jkSumMultiplier")}.}
}
\value{
a numeric value; the jackknife covariance estimate
}
\description{
When the variance of a derived statistic (e.g., a difference) is 
             required, the covariance between the two statistics must be 
             calculated. This function uses results generated by various
             functions (e.g., a \code{\link{lm.sdf}}) to find the covariance
             between two statistics.
}
\details{
Note that these functions are not vectorized, so \code{varA} and 
\code{varB} must contain exactly one variable name.

The method used to compute the covariance is in
the vignette titled
\href{https://www.air.org/sites/default/files/EdSurvey-Statistics.pdf}{Statistics}
in the section \dQuote{Estimation of Covariances.}

The method used to compute the degrees of freedom is in the vignette titled
\href{https://www.air.org/sites/default/files/EdSurvey-Statistics.pdf}{Statistics}
in the section \dQuote{Estimation of Degrees of Freedom.}
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# estimate a regression
lm1 <- lm.sdf(composite ~ dsex + b017451, sdf, returnVarEstInputs=TRUE)
summary(lm1)
# estimate the covariance between two regression coefficients
# note that the variable names are parallel to what they are called in lm1 output
covFEveryDay <- varEstToCov(lm1$varEstInputs,
                            varA="dsexFemale",
                            varB="b017451Every day",
                            jkSumMultiplier=EdSurvey:::getAttributes(sdf, "jkSumMultiplier"))
# the estimated difference between the two coefficients
# note: unname prevents output from being named after the first coefficient
unname(coef(lm1)["dsexFemale"] - coef(lm1)["b017451Every day"])
# the standard error of the difference
# uses the formula SE(A-B) = sqrt(var(A) + var(B) - 2*cov(A,B))
sqrt(lm1$coefmat["dsexFemale", "se"]^2
     + lm1$coefmat["b017451Every day", "se"]^2
     - 2 * covFEveryDay)
}
\author{
Paul Bailey
}
