% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed.sdf.R
\name{mixed.sdf}
\alias{mixed.sdf}
\title{EdSurvey Mixed-Effects Model}
\usage{
mixed.sdf(formula, data, weightVars = NULL,
  weightTransformation = TRUE, recode = NULL,
  defaultConditions = TRUE, tolerance = 0.01, nQuad = NULL,
  verbose = 0, family = NULL, centerGroup = NULL,
  centerGrand = NULL, fast = FALSE, ...)
}
\arguments{
\item{formula}{a \ifelse{latex}{\code{formula}}{\code{\link[stats]{formula}}}
for the multilevel regression or mixed model. See Examples and the vignette titled 
\emph{\href{https://www.air.org/sites/default/files/EdSurvey-Mixed_Models.pdf}{Methods Used for Estimating Mixed-Effects Models in EdSurvey}}
for more details on how to specify a mixed model. If \emph{y} is
left blank, the default subject scale or subscale variable
will be used. (You can find the default using
\code{\link{showPlausibleValues}}.) If \emph{y} is a variable
for a subject scale or subscale (one of the names shown by
\code{\link{showPlausibleValues}}), then that subject scale
or subscale is used.

For logistic models, we recommend using the \code{I()} function 
   to define the level used for success. (See Examples.)}

\item{data}{an \code{edsurvey.data.frame} or a \code{light.edsurvey.data.frame}}

\item{weightVars}{character vector indicating weight variables for
corresponding levels to use. The \code{weightVar} must be
the weights for the \code{edsurvey.data.frame}. The weight variables
must be in the order of level (from lowest to highest level).}

\item{weightTransformation}{a logical value to indicate whether the function
should standardize weights before using it in the
multilevel model. If set to \code{TRUE}, the
function will look up standard weight
transformation methods often used for a specific
survey. Weight transformation can be found in the vignette titled 
\emph{\href{https://www.air.org/sites/default/files/EdSurvey-Mixed_Models.pdf}{Methods Used for Estimating Mixed-Effects Models in EdSurvey}}.
If set to \code{FALSE} or if the survey of the specified \code{data} does
not have a standard weight transformation method,
raw weights will be used.}

\item{recode}{a list of lists to recode variables. Defaults to \code{NULL}. Can be set as
\code{recode=}\code{list(}\code{var1} \code{=} \code{list(}\code{from=} \code{c("a",} \code{"b",} \code{"c"),} \code{to=} \code{"d"))}. 
See Examples in \ifelse{latex}{\code{lm.sdf}}{\code{\link{lm.sdf}}}.}

\item{defaultConditions}{a logical value. When set to the default value of
\code{TRUE}, uses the default conditions stored in
an \code{edsurvey.data.frame} to subset the data.
Use \code{print} on an \code{edsurvey.data.frame}
to see the default conditions.}

\item{tolerance}{a numeric value to indicate how accurate the result is.
See Details for more information. Defaults to 0.01.}

\item{nQuad}{an integer to indicate the number of quadrature points in
adaptive quadrature process. See documentation of
\ifelse{latex}{\code{WeMix::mix}}{\code{\link[WeMix]{mix}}} 
for more details on how \code{nQuad} affects
the estimation. If no \code{nQuad} is set, function will start with 
\code{nQuad = 5} and increase until a stable result is reached. See details for 
further discussion.}

\item{verbose}{an integer; when set to \code{1}, it will print out
the brief progress of the function \code{mix.sdf}.
Users can use these traced messages for further diagnosis.
When set to \code{2}, it will print
out the detailed progress, including temporary estimates
   during the optimization. Defaults to \code{0}, which 
   will run the function without output.}

\item{family}{an element of \ifelse{latex}{\code{family}}{\code{\link[stats]{family}}} class; optionally used 
to specify generalized linear mixed models.
Defaults to \code{NULL}, which runs mixed linear regression models. Another 
family option is \code{binomial(link="logit")} to run binomial mixed models.}

\item{centerGroup}{a list in which the name of each element is the name of the aggregation level, 
and the element is a formula of variable names to be group mean centered. For example, to group mean center
 gender and age within the group student: \code{list("student"= ~gender+age)}. Defaults to \code{NULL}, which means 
 predictors are not adjusted by group centering. See Examples in \ifelse{latex}{\code{mix}}{\code{\link[WeMix]{mix}}}.}

\item{centerGrand}{a formula of variable names to be grand mean centered. For example, to center the 
variable education by overall mean of education: \code{~education}. Defaults to \code{NULL}, which means predictors
are not adjusted by grand centering.}

\item{fast}{a logical value; when set to \code{TRUE}, use  c++ function for faster result. Defaults to \code{FALSE}.}

\item{...}{other potential arguments to be used in \ifelse{latex}{\code{mix}}{\code{\link[WeMix]{mix}}}}
}
\value{
A \code{mixedSdfResults} object with the following elements:
   \item{call}{the original call used in \code{mixed.sdf} }
   \item{formula}{the formula used to fit the model}
   \item{coef}{the estimates of the coefficients}
   \item{se}{the standard error estimates of the coefficients}
   \item{vars}{variance components of the model }
   \item{levels}{the  number of levels in the model }
   \item{ICC}{the intraclass correlation coefficient of the model }
   \item{npv}{the number of plausible values}
   \item{ngroups}{a \code{data.frame} that includes number of observations for each group}
If the formula does not involve plausible values, the function will return the following additional elements:
   \item{lnlf}{the likelihood function } 
   \item{lnl}{the log-likelihood of the model }
If the formula involves plausible values, the function will return the following additional elements:
   \item{Vimp}{the estimated variance from uncertainty in the scores}
   \item{Vjrr}{the estimated variance from sampling}
}
\description{
Fits a linear or logistic weighted mixed-effects model.
}
\details{
If users do not specify the \code{nQuad} argument, the functions will
         use the \code{tolerance} argument to repeatedly run the mixed model and increment
         \code{nQuad} (starting at 5) until the percentage of difference between the
         log-likelihood of the new model and the old model is smaller than
         \code{tolerance}. If users provide  \code{nQuad}, selecting a smaller value of \code{nQuad} 
         can save processing time; however, it is recommended that users try incrementing
           \code{nQuad} to check whether the result is stable.
         
         Note that if the outcome variable has plausible values, the previous setting will be 
         applied to the estimation of all plausible values.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package = "NAEPprimer"))

# subset to a smaller sample
sdf_subset <- subset(sdf, scrpsu < 500)

# fast is an argument from WeMix::mix that allows the function to run faster using c++
m1 <- mixed.sdf(composite ~ dsex + b017451 + (1|scrpsu), data=sdf_subset,
                weightVar = c('origwt', 'srwt01'),
                fast=TRUE, verbose=1)
summary(m1)

# Run multilevel logistic regression model
# nQuad is specified to be 7, which means 
# the function will use 7 quadrature points for the integration
m2 <- mixed.sdf(I(composite >= 214) ~ (1|scrpsu), 
                data=sdf_subset, family = binomial(link="logit"),
                weightVar = c('origwt', 'srwt01'), 
                nQuad = 7, verbose=1)
summary(m2)
}
}
\references{
Rabe-Hesketh, S., & Skrondal, A. (2006). Multilevel modelling of complex
survey data. \emph{Journal of the Royal Statistical Society: Series A
(Statistics in Society), 169}(4), 805--827.
}
\seealso{
\ifelse{latex}{\code{mix}}{\code{\link[WeMix]{mix}}} and \ifelse{latex}{\code{lm.sdf}}{\code{\link{lm.sdf}}}
}
\author{
Trang Nguyen and Claire Kelley
}
