% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eztune.cv.R
\name{eztune.cv}
\alias{eztune.cv}
\title{Cross-Validated Accuracy for Supervised Learning Model}
\usage{
eztune.cv(x, y, model, fold = 10)
}
\arguments{
\item{x}{Matrix or data frame containing the dependent variables used
to create the model.}

\item{y}{Numeric vector of 0s and 1s for the response used to create
the model.}

\item{model}{Object generated with the function eztune.}

\item{fold}{Number of folds to use for n-fold cross validation.}
}
\value{
Function returns a numeric value that represents the
cross-validated accuracy of the model.
}
\description{
eztune.cv is a function that will return the cross-validated
accuracy for a model generated by the function eztune.
The function eztune can tune a model using resubstitution or
cross-validation. If the resubstitution is used to tune the model, the
accuracy obtained from the function is inflated. The function
eztune.cv will return a cross-validated accuracy for such a model.
}
\examples{
library(mlbench)
data(Glass)

glass <- Glass[as.numeric(as.character(Glass$Type)) < 3, ]
glass <- glass[sample(1:nrow(glass), 80), ]
y <- ifelse(glass$Type == 1, 0, 1)
x <- glass[, 1:9]

glass_svm <- eztune(x, y, type = "binary", method = "svm")
eztune.cv(x, y, glass_svm)

}
\keyword{adaboost,}
\keyword{cross-validation}
\keyword{gbm,}
\keyword{svm,}
\keyword{tuning,}
