% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moses.list.R
\name{moses.list}
\alias{moses.list}
\title{Takes a list of enmtools.species objects and uses model selection to ask whether they're better treated jointly or separately}
\usage{
moses.list(
  species.list,
  env,
  f = NULL,
  eval = FALSE,
  nback = 1000,
  bg.source = "default",
  ...
)
}
\arguments{
\item{species.list}{A list of enmtools.species objects, or an enmtools.clade object.}

\item{env}{A raster or raster stack of environmental data.}

\item{f}{A GLM-style function for model fitting}

\item{eval}{Boolean indicating whether or not GLMs should be evaluated using AUC/TSS/etc.}

\item{nback}{Number of background points to generate, if any}

\item{bg.source}{Source for drawing background points.  If "points", it just uses the background points that are already in the species object.  If "range", it uses the range raster.  If "env", it draws points at randome from the entire study area outlined by the first environmental layer.}

\item{...}{further arguments to be passed to enmtools.glm}
}
\value{
A list containing GLMs for the groups separately and together, as well as AIC values for those models.
}
\description{
Takes a list of enmtools.species objects and uses model selection to ask whether they're better treated jointly or separately
}
