% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enmtools.dm.R
\name{enmtools.dm}
\alias{enmtools.dm}
\title{Takes an emtools.species object with presence and background points, and builds a Domain model}
\usage{
enmtools.dm(
  species,
  env = NA,
  test.prop = 0,
  report = NULL,
  nback = 1000,
  env.nback = 10000,
  overwrite = FALSE,
  rts.reps = 0,
  bg.source = "default",
  ...
)
}
\arguments{
\item{species}{An enmtools.species object}

\item{env}{A raster or raster stack of environmental data.}

\item{test.prop}{Proportion of data to withhold randomly for model evaluation, or "block" for spatially structured evaluation.}

\item{report}{Optional name of an html file for generating reports}

\item{nback}{Number of background points for models.  In the case of Domain, these are only used for evaluation.}

\item{env.nback}{Number of points to draw from environment space for environment space discrimination metrics.}

\item{overwrite}{TRUE/FALSE whether to overwrite a report file if it already exists}

\item{rts.reps}{The number of replicates to do for a Raes and ter Steege-style test of significance}

\item{bg.source}{Source for drawing background points.  If "points", it just uses the background points that are already in the species object.  If "range", it uses the range raster.  If "env", it draws points at randome from the entire study area outlined by the first environmental layer.}

\item{...}{Arguments to be passed to domain()}
}
\value{
An enmtools model object containing species name, model formula (if any), model object, suitability raster, marginal response plots, and any evaluation objects that were created.
}
\description{
Takes an emtools.species object with presence and background points, and builds a Domain model
}
\examples{
\donttest{
data(euro.worldclim)
data(iberolacerta.clade)
enmtools.dm(iberolacerta.clade$species$monticola, env = euro.worldclim)
}
}
