% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{compare}
\alias{compare}
\title{Information criteria and marginal likelihoods}
\usage{
compare(
  sList,
  stage = "sample",
  filter = NULL,
  use_best_fit = TRUE,
  BayesFactor = TRUE,
  cores_for_props = 4,
  cores_per_prop = 1,
  print_summary = TRUE,
  digits = 0,
  digits_p = 3,
  ...
)
}
\arguments{
\item{sList}{List of samples objects}

\item{stage}{A string. Specifies which stage the samples are to be taken from \code{"preburn"}, \code{"burn"}, \code{"adapt"}, or \code{"sample"}}

\item{filter}{An integer or vector. If it's an integer, iterations up until the value set by \code{filter} will be excluded.
If a vector is supplied, only the iterations in the vector will be considered.}

\item{use_best_fit}{Boolean, defaults to \code{TRUE}, uses the minimal or mean likelihood (whichever is better) in the
calculation, otherwise always uses the mean likelihood.}

\item{BayesFactor}{Boolean, defaults to \code{TRUE}. Include marginal likelihoods as estimated using WARP-III bridge sampling.
Usually takes a minute per model added to calculate}

\item{cores_for_props}{Integer, how many cores to use for the Bayes factor calculation, here 4 is the default for the 4 different proposal densities to evaluate, only 1, 2 and 4 are sensible.}

\item{cores_per_prop}{Integer, how many cores to use for the Bayes factor calculation if you have more than 4 cores available. Cores used will be cores_for_props * cores_per_prop. Best to prioritize cores_for_props being 4 or 2}

\item{print_summary}{Boolean (default \code{TRUE}), print table of results}

\item{digits}{Integer, significant digits in printed table for information criteria}

\item{digits_p}{Integer, significant digits in printed table for model weights}

\item{...}{Additional, optional arguments}
}
\value{
Matrix of effective number of parameters, mean deviance, deviance of
mean, DIC, BPIC, Marginal Deviance (if \code{BayesFactor=TRUE}) and associated weights.
}
\description{
Returns the BPIC/DIC or marginal deviance (-2*marginal likelihood) for a list of samples objects.
}
\examples{
\dontrun{
# Define a list of two (or more different models)
# Here the full model is an emc object with the hypothesized effect
# The null model is an emc object without the hypothesized effect
design_full <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))
# Now without a ~ E
design_null <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~1, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))

full_model <- make_emc(forstmann, design_full)
full_model <- fit(full_model)

null_model <- make_emc(forstmann, design_null)
null_model <- fit(null_model)
sList <- list(full_model, null_model)
# By default emc uses 4 cores to parallelize marginal likelihood estimation across proposals
# So cores_per_prop = 3 results in 12 cores used.
compare(sList, cores_per_prop = 3)
}
}
