% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runGroupBoot.R
\name{runGroupsBoot}
\alias{runGroupsBoot}
\title{The bootstrap uncertainty analysis for runGroups results}
\usage{
runGroupsBoot(eList, groupResults, nBoot = 100, startSeed = 494817,
  blockLength = 200)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{groupResults}{data frame returned from \code{\link[EGRET]{runGroups}}}

\item{nBoot}{the maximum number of bootstrap replicates to be used, typically 100}

\item{startSeed}{setSeed value. Defaults to 494817. This is used to make repeatable output.}

\item{blockLength}{days, typically 200 is a good choice}
}
\value{
eBoot, a named list with bootOut,wordsOut,xConc,xFlux values. bootOut is a data frame with the results
of the bootstrapping tests. wordsOut is a character vector describing the results.
xConc, xFlux are vectors of length iBoot, of the change in flow normalized concentration or flux 
computed by each bootstrap replicate (mg/L). pConc and pFlux are vectors of length iBoot, of the change 
in flow normalized concentration or flux computed from each bootstrap replicate expressed as % change.
}
\description{
This function that does the uncertainty analysis for determining the change 
between two groups of years.  The process is virtually 
identical to what is used for \code{\link{runPairsBoot}}.
}
\examples{
library(EGRET)
eList <- Choptank_eList

\dontrun{
groupResults <- runGroups(eList, 
                          group1firstYear = 1995, 
                          group1lastYear = 2004, 
                          group2firstYear = 2005, 
                          group2lastYear = 2014, 
                          windowSide = 7, wall = TRUE, 
                          sample1EndDate = "2004-10-30", 
                          paStart = 4, paLong = 2, 
                          verbose = FALSE)

boot_group_out <- runGroupsBoot(eList, groupResults)

plotHistogramTrend(eList, boot_group_out, caseSetUp=NA)
}
}
\seealso{
\code{\link{runPairsBoot}}, \code{\link[EGRET]{runGroups}}
}
