% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invariance.R
\name{invariance}
\alias{invariance}
\title{Measurement Invariance of \code{\link[EGAnet]{EGA}} Structure}
\usage{
invariance(
  data,
  groups,
  memberships = NULL,
  type = c("loadings"),
  iter = 500,
  ncores,
  ...
)
}
\arguments{
\item{data}{Matrix or data frame.
Variables to be used in the analysis}

\item{groups}{Vector.
Group membership corresponding to each case in data}

\item{memberships}{Vector. 
Node membership for each community or factor. 
Defaults to \code{NULL}.
When \code{NULL}, \code{\link[EGAnet]{EGA}} is used to compute node memberships}

\item{type}{Character.
Type of measurement invariance to estimate.
Only includes \code{"loadings"} at the moment}

\item{iter}{Numeric. 
Number of iterations to perform for the permutation.
Defaults to \code{500}}

\item{ncores}{Numeric.
Number of cores to use in computing results.
Defaults to \code{parallel::detectCores() / 2} or half of your
computer's processing power.
Set to \code{1} to not use parallel computing

If you're unsure how many cores your computer has,
then use the following code: \code{parallel::detectCores()}}

\item{...}{Arguments passed to \code{\link[EGAnet]{EGA}}}
}
\value{
Returns a list containing:

\item{memberships}{Original memberships provided in \code{memberships}
or from \code{\link[EGAnet]{EGA}} if \code{NULL}}

\item{EGA}{Original \code{\link[EGAnet]{EGA}} results for the sample}

\item{groups}{

\itemize{

\item{\code{\link[EGAnet]{EGA}}}
{EGA results for each group}

\item{\code{loadings}}
{Network loadings for each group}

\item{\code{loadingsDifference}}
{Difference between the dominant loadings of each group}

}

}

\item{permutation}{

\itemize{

\item{\code{groups}}
{Permutated groups acorss iterations}

\item{\code{loadings}}
{Loadings for each group for each permutation}

\item{\code{loadingsDifference}}
{Difference between the dominant loadings of each group for each permutation}

}

}

\item{results}{Data frame of the results (which are printed)}
}
\description{
Estimates metric invariance of \code{\link[EGAnet]{EGA}} or specified structure
}
\examples{
# Load data
wmt <- wmt2[-1,7:24]

# Groups
groups <- rep(1:2, each = nrow(wmt) / 2)

\donttest{
# Measurement invariance
results <- invariance(wmt, groups, ncores = 2)}

}
\author{
Laura Jamison <lj5yn@virginia.edu>,
Alexander P. Christensen <alexpaulchristensen@gmail.com>, and 
Hudson F. Golino <hfg9s at virginia.edu>
}
