% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figures.R
\name{isolateCharacterSpeech}
\alias{isolateCharacterSpeech}
\title{Isolate Character Speech}
\usage{
isolateCharacterSpeech(drama, segment = c("Drama", "Act", "Scene"),
  minTokenCount = 0, countPunctuation = TRUE, writeToFiles = TRUE,
  dir = getOption("qd.datadir"))
}
\arguments{
\item{drama}{A text (or multiple texts, as a QDDrama object)}

\item{segment}{"Drama", "Act", or "Scene". Determines on what segment-level the speech is isolated.}

\item{minTokenCount}{The minimal token count for a speech to be considered (default = 0)}

\item{countPunctuation}{Whether to include punctuation in minTokenCount (default = TRUE)}

\item{writeToFiles}{Whether to write each isolated speech into a new text file (default = TRUE)}

\item{dir}{The directory into which the files will be written (default = data directory)}
}
\value{
A named list of character vectors, each corresponding to character speeches as defined by \code{segment}
}
\description{
\code{isolateCharacterSpeech()} isolates the speeches
of individual characters and optionally saves them in seperate text files.
}
\examples{
data(rksp.0)
isolateCharacterSpeech(rksp.0, segment="Scene", writeToFiles=FALSE)
}
