% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortingWines.R
\docType{data}
\name{sortingWines}
\alias{sortingWines}
\title{Novices and wines experts sort red, rosé, and white wines}
\format{
a list containing 4 objects:
 1) \code{freeSortExperts}:
 a data frame with the 18 wines by 19 experts free sorting data
  (the number at the intersection of a row and a colum
  indicates the number of the pile in which the wine was sorted);
2) \code{ternarySortExperts}:
 a data frame with the 18 wines by 19 experts ternary
 (i.e., in three piles) sorting data
  (the number at the intersection of a row and a colum
  indicates the number of the pile in which the wine was sorted);
 3) \code{$ternarySortNovices}:
 a data frame with the 18 wines by 19 nivices ternary
 (i.e., in three piles) sorting data
  (the number at the intersection of a row and a colum
  indicates the number of the pile in which the wine was sorted);
  and 4)
\code{vinesDescription} a data frame
storing the description of the 18 wines.
}
\usage{
data("sortingWines")
}
\description{
\code{sortingWines}: 26 novices participants
 and 19 wine experts sort (by smell alone, 
 without visual information) 18 wines (6 red, 6 rosé, and 6 whites)
into three categories. The experts also performed a free
sorting task on the wines (i.e. with as many groups as the wished).

The data consist in
a list containing 4 objects:
 1) \code{freeSortExperts}:
 a data frame with the 18 wines by 19 experts free sorting data
  (the number at the intersection of a row and a colum
  indicates the number of the pile in which the wine was sorted);
2) \code{ternarySortExperts}:
 a data frame with the 18 wines by 19 experts ternary
 (i.e., in three piles) sorting data
  (the number at the intersection of a row and a colum
  indicates the number of the pile in which the wine was sorted);
 3) \code{$ternarySortNovices}:
 a data frame with the 18 wines by 19 novices ternary
 (i.e., in three piles) sorting data
  (the number at the intersection of a row and a colum
  indicates the number of the pile in which the wine was sorted);
  and 4)
\code{vinesDescription} a data frame
storing the description of the 18 wines.
}
\details{
The wines were served in dark glasses and the sorting task
was performed with red light (this way 
all wines look black). In the experiment, 
the wines were labeled with three-digit codes, for more details 
see Ballester \emph{et al.} (2009).
Only the experts performed the free sorting task.

In the data sets, the wines are identified with shortened
names, the whole names can be found in the data frame.
All the wines were from the 2005 vintage 
(see Ballester \emph{et al.}, 2009 for details)

Compared to the original data, some missing data were added
to the set after imputation of the missing data 
(a total of 4 entries). The current data include 
only 19 experts out the original 27 experts.
\code{vinesDescription}.
}
\references{
For more details see:
 
Ballester, J., Abdi, H., Langlois, J., Peyron, D., & Valentin, D.
(2009). {The odor of colors: Can wine experts and novices
distinguish the odors of white, red, and rosé wines?}
\emph{Chemosensory Perception, 2}, 203-213.
}
\author{
Ballester, J., Abdi, H., Langlois, J., 
Peyron, D., & Valentin, D.
}
\keyword{DistatisR}
\keyword{datasets}
