% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeSplus.R
\name{ComputeSplus}
\alias{ComputeSplus}
\title{ComputeSplus}
\usage{
ComputeSplus(CubeCP, alpha)
}
\arguments{
\item{CubeCP}{A 3D array of cross-product matrices.}

\item{alpha}{The vector of weights}
}
\value{
The compromise matrix
computed as the alpha-weighted sum of the 
cross-product matrices.
}
\description{
Compute the compromise matrix for STATIS/DISTATIS
}
\examples{
\donttest{
D3 <- array(c(0, 1, 2, 1, 0, 1, 2, 1, 0, 
              0, 3, 3, 3, 0, 3, 3, 3, 0), 
            dim = c(3, 3, 2))
ComputeSplus(D3, alpha = c(1, 0.5))
}
}
