
<!-- README.md is generated from README.Rmd. Please edit that file -->

# DependencyReviewer

<!-- badges: start -->

[![R-CMD-check](https://github.com/darwin-eu-dev/DependencyReviewer/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/darwin-eu-dev/DependencyReviewer/actions/workflows/R-CMD-check.yaml)
![](https://www.r-pkg.org/badges/version/DependencyReviewer?colour=blue)
![](https://cranlogs.r-pkg.org/badges/grand-total/DependencyReviewer)
<!-- badges: end -->

DependencyReviewer is a package that Helps investigating other packages
during code review by looking at their dependencies.

## Features

- Check your used dependencies against the Darwin-EU white list.
- Easily review your function use per dependency for your package.
- An easy way to get graph data of all your dependencies to see how your
  package depends on any (transitive) dependencies.
- Use predefined Darwin Lint functions to lint your package.
- Easily calculate percentages of how many style, warning, and error
  messages are encountered across your package.
- A shiny app to interactively investigate your package.

## Installation <a name="Installation"></a>

You can install the development version of DependencyReviewer like so:

``` r
install.packages("remotes")
remotes::install_github("darwin-eu-dev/DependencyReviewer")
```

DependencyReviewer is now available on CRAN.

``` r
install.packages("DependencyReviewer")
```

## Features wishlist

- Show lintr output in the shinyApp
- Show test coverage in the shinyApp
- Include spelling checking using `spelling::spell_check_package`
- An automated way to ‘plot’ out your package functions (UML-like).
