% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KnnUpdate.R
\name{KnnUpdate}
\alias{KnnUpdate}
\title{KNN : Update}
\usage{
KnnUpdate(knnMdl, newData)
}
\arguments{
\item{knnMdl}{a list containing:
 \itemize{
  \item knnMdl$data - The data set provided by user
  \item knnMdl$xCol - The column number of features provided by user or the best subset column number
  \item knnMdl$yCol - The column number of target provided by user
  \item knn$bestK - The best k nearest neighbor calculated using the function KnnFit
}}

\item{newData}{a dataframe or a matrix, to be used for updating the model}
}
\value{
a list containing :
 \itemize{
  \item data - The updated data using old data set and new data
  \item xCol - The column number of features provided by user or the best subset column number
  \item yCol - The column number of target provided by user
  \item bestK - The best k nearest neighbor calculated for the new data using user specified features and target
}
}
\description{
The function can be used to update KNN model when new data is provided
}
\examples{

data = data1[c(1:100),]
xCol = 2
yCol = 7
subsetSelection = FALSE

knn_model = KnnPCFit(data, xCol, yCol, subsetSelection)
newData = data1[c(101:110), ]

knn_newmodel = KnnUpdate(knn_model, newData)

}
