% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KnnPCFit.R
\name{KnnPCFit}
\alias{KnnPCFit}
\title{KNN : Fit}
\usage{
KnnPCFit(data, xCol, yCol, subsetSelection = FALSE)
}
\arguments{
\item{data}{a dataframe or a matrix, to be used in modelling}

\item{xCol}{a vector or numeric values stating the column number of features}

\item{yCol}{a numerical or a vector value stating the column number of target}

\item{subsetSelection}{a boolean, default value is FALSE, if TRUE returns the best feature column number as xCol}
}
\value{
a list containing :
 \itemize{
  \item data - The data set provided by user
  \item xCol - The column number of features provided by user or the best subset column number
  \item yCol - The column number of target provided by user
  \item bestK - The best k nearest neighbor calculated using the function
  \item RMSE - The RMSE calculated using the function for provided data using user defined features and best obtained K
  \item MAE - The MAE calculated using the function for provided data using user defined features and best obtained K
}
}
\description{
The function models the powercurve using KNN, against supplied arguments
}
\examples{

data = data1[c(1:100),]
xCol = 2
yCol = 7
subsetSelection = FALSE

knn_model = KnnPCFit(data, xCol, yCol, subsetSelection)

}
