% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KnnPredict.R
\name{KnnPredict}
\alias{KnnPredict}
\title{KNN : Predict}
\usage{
KnnPredict(knnMdl, testData)
}
\arguments{
\item{knnMdl}{a list containing:
 \itemize{
  \item knnMdl$data - The data set provided by user
  \item knnMdl$xCol - The column number of features provided by user or the best subset column number
  \item knnMdl$yCol - The column number of target provided by user
  \item knn$bestK - The best k nearest neighbor calculated using the function KnnFit
}}

\item{testData}{a data frame or matrix, to compute the predictions}
}
\value{
a numeric / vector with prediction on test data using model generated by KnnFit
}
\description{
The function can be used to make prediction on test data using trained model
}
\examples{

data = data1[c(1:100),]
xCol = 2
yCol = 7
subsetSelection = FALSE

knn_model = KnnPCFit(data, xCol, yCol, subsetSelection)
testData = data1[c(101:110), ]

prediction = KnnPredict(knn_model, testData)

}
