% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeWeightedDifference.R
\name{ComputeWeightedDifference}
\alias{ComputeWeightedDifference}
\title{Percentage weighted difference between power curves}
\usage{
ComputeWeightedDifference(
  muDiff,
  weights,
  base,
  statDiff = FALSE,
  confBand = NULL
)
}
\arguments{
\item{muDiff}{a vector of pointwise difference between two power curves on a testset as obtained from \code{ComparePCurve()} or \code{funGP()} function.}

\item{weights}{a vector of user specified weights for each element of \code{muDiff}. It can be based on any probability distribution of user's choice. The weights must sum to 1.}

\item{base}{a vector of predictions from a power curve; to be used as the denominator in computing the percentage difference. It can be either \code{mu1} or \code{mu2} as obtained from \code{ComparePCurve()} or \code{funGP()} function.}

\item{statDiff}{a boolean specifying whether to compute the statistical significant difference or not. Default is set to \code{FALSE}, i.e. statistical significant difference is not computed. If set to \code{TRUE}, \code{confBand} must be provided.}

\item{confBand}{a vector of pointwise confidence band for all the points in the testset as obtained from \code{ComparePCurve()} or \code{funGP()} function, named as \code{band}. Should only be provided when \code{statDiff} is set to \code{TRUE}. Default value is \code{NULL}.}
}
\value{
a numeric percentage weighted difference or statistical significant percetage weighted difference based on whether statDiff is set to \code{FALSE} or \code{TRUE}.
}
\description{
Computes percentage weighted difference between power curves based on user provided weights instead of the weights computed from the data. Please see \code{details} for more information.
}
\details{
The function is a modification to the percentage weighted difference defined in Ding et al. (2021). It computes a weighted difference between power curves on a testset, where the weights have to be provided by the user based on any probability distribution of their choice rather than the weights being computed from the data. The weights must sum to 1 to be valid.
}
\examples{

ws_test = as.matrix(seq(4.5,8.5,length.out = 10))

userweights = dweibull(ws_test, shape = 2.25, scale = 6.5) 
userweights = userweights/sum(userweights) 
data1 = data1[1:100, ]
data2 = data2[1:100, ]
datalist = list(data1, data2)
xCol = 2
xCol.circ = NULL
yCol = 7
testCol = 2
output = ComparePCurve(data = datalist, xCol = xCol, yCol = yCol, 
testCol = testCol, testSet = ws_test) 
weightedDiff = ComputeWeightedDifference(output$muDiff, userweights, output$mu1)
weightedStatDiff = ComputeWeightedDifference(output$muDiff, userweights, output$mu1, 
statDiff = TRUE, confBand = output$band)

}
\references{
For details, see Ding et al. (2021) available at \doi{10.1016/j.renene.2021.02.136}.
}
