\name{BLCA}

\docType{data}

\alias{BLCA}

\title{Single paired M-values of BLCA chr18 from TCGA}

\description{

	This data set contains one pair of M-values of BLCA chr18 from 
	The Cancer Genome Atlas TCGA (TCGA).
	In addition, it contains the distance between each probes and the 
	gold standard methylation status getting by the matched WGBS data 
	(also from TCGA).
	
}

\usage{data(BLCA)}

\format{
  A List with the following items, all items will length 5492 corresponding
  to the Illumina 450K probes on chr18:
  \describe{
	\item{mv}{A matrix with one pair of M-values}
	\item{distance}{a numeric vector of the probe distance}
	\item{truth}{a binary vector represents the WGBS 
	methylation status (0-nDML, 1-DML)}
  }
}

\source{
	Data generated by the TCGA Research Network:
	<http://cancergenome.nih.gov/>
}

\examples{
data(BLCA)
}
