% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIscBIO-generic-Exprmclust.R
\name{Exprmclust}
\alias{Exprmclust}
\alias{Exprmclust,DISCBIO-method}
\alias{Exprmclust,data.frame-method}
\title{Performing Model-based clustering on expression values}
\usage{
Exprmclust(
  object,
  K = 3,
  modelNames = "VVV",
  reduce = TRUE,
  cluster = NULL,
  quiet = FALSE
)

\S4method{Exprmclust}{DISCBIO}(
  object,
  K = 3,
  modelNames = "VVV",
  reduce = TRUE,
  cluster = NULL,
  quiet = FALSE
)

\S4method{Exprmclust}{data.frame}(
  object,
  K = 3,
  modelNames = "VVV",
  reduce = TRUE,
  cluster = NULL,
  quiet = FALSE
)
}
\arguments{
\item{object}{\code{DISCBIO} class object.}

\item{K}{An integer vector specifying all possible cluster numbers. Default
is 3.}

\item{modelNames}{model to be used in model-based clustering. By default
"ellipsoidal, varying volume, shape, and orientation" is used.}

\item{reduce}{A logical vector that allows performing the PCA on the
expression data. Default is TRUE.}

\item{cluster}{A vector showing the ID of cells in the clusters.}

\item{quiet}{if `TRUE`, suppresses intermediary output}
}
\value{
If `object` is of class DISCBIO, the output is the same object  with
  the MBclusters slot filled. If the `object` is a data frame, the function
  returns a named list containing the four objects that together correspond
  to the contents of the MBclusters slot.
}
\description{
this function first uses principal component analysis (PCA) to
  reduce dimensionality of original data. It then performs model-based
  clustering on the transformed expression values.
}
