% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vital_signs.R
\docType{data}
\name{vital_signs}
\alias{vital_signs}
\title{DIVINE's table on vital signs}
\format{
A data frame with 5813 rows and 13 columns
\describe{
\item{record_id:}{Identifier of each record. This information does not match the real data.}
\item{covid_wave:}{A factor with levels \verb{Wave 1}, \verb{Wave 2}, \verb{Wave 3}, and \verb{Wave 5}. COVID-19 wave.}
\item{center:}{A factor with levels \verb{Hospital A}, \verb{Hospital B}, \verb{Hospital C}, \verb{Hospital D}, and \verb{Hospital E}. Center of admission}
\item{temperature:}{Human body temperature (ºC)}
\item{fio2_contributed:}{Fraction of inspired oxygen (\%)}
\item{syst_blood_press:}{Systolic blood pressure (mmHg)}
\item{diast_blood_press:}{Diastolic blood pressure (mmHg)}
\item{saturation:}{Oxygen saturation (\%)}
\item{cardiac_freq:}{Heart rate (bpm)}
\item{supporto2:}{A factor with levels \code{No} and \code{Yes}. Oxygen Support}
\item{normal_radio:}{A factor with levels \code{No} and \code{Yes}. Normal X-ray}
\item{pleural_effusion:}{A factor with levels \code{No} and \code{Yes}. Pleural effusion}
\item{saturation_fio2:}{Oxygen Saturation to FiO2 Ratio}
}
}
\usage{
data(vital_signs)
}
\description{
Information on vital signs of patients included in the DIVINE cohort. Data was collected at hospital admission.
}
\references{
Pallarès, N., Tebé, C., Abelenda-Alonso, G., Rombauts, A., Oriol, I., Simonetti, A. F., Rodríguez-Molinero, A., Izquierdo, E., Díaz-Brito, V., Molist, G., Gómez Melis, G., Carratalà, J., Videla, S., & MetroSud and Divine study groups (2023). Characteristics and Outcomes by Ceiling of Care of Subjects Hospitalized with COVID-19 During Four Waves of the Pandemic in a Metropolitan Area: A Multicenter Cohort Study. Infectious diseases and therapy, 12(1), 273–289. https://doi.org/10.1007/s40121-022-00705-w
}
\keyword{datasets}
