% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_data.R
\name{export_data}
\alias{export_data}
\title{Export Data to Various Formats}
\usage{
export_data(data = NULL, path = NULL, format = NULL)
}
\arguments{
\item{data}{A dataframe or tibble to export.}

\item{path}{A character string specifying the file path for the exported file.}

\item{format}{Optional character string specifying the export format. Supported formats:
"xlsx", "csv", "rds", "txt", "sav", "dta", "sas7bdat" (alias "xpt"). If NULL (default),
the function infers the format from the \code{path} extension.}
}
\value{
This function does not return a value. It writes the data to the specified file path and displays a success message upon completion.
}
\description{
Export a dataframe or tibble to multiple file formats. If \code{format} is NULL (default),
the format will be inferred from the file extension of \code{path}. If \code{format} is provided
and the extension in \code{path} does not match, the function will update the path to
use the extension that corresponds to \code{format} and warn the user.
}
\details{
Supported formats and their functionality are provided via the package dependencies:
\itemize{
\item \strong{xlsx}: Uses \code{openxlsx} for Excel exports.
\item \strong{csv}: Base R functionality.
\item \strong{rds}: Base R functionality.
\item \strong{txt}: Base R functionality with tab-separated values.
\item \strong{sav}: Uses \code{haven} for SPSS exports.
\item \strong{dta}: Uses \code{haven} for Stata exports.
\item \strong{sas7bdat}: Uses \code{haven} for SAS exports.
}
}
\examples{
\dontrun{
df <- data.frame(Name = c("Alice", "Bob"), Age = c(25, 30))

# Infer format from path extension (no format argument)
export_data(df, path = "example.xlsx")
export_data(df, path = "example.csv")

# Explicit format (function will ensure path extension matches)
export_data(df, format = "csv", path = "example")         # adds .csv
export_data(df, format = "rds", path = "example.rds")
}

}
