% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comorbidities.R
\docType{data}
\name{comorbidities}
\alias{comorbidities}
\title{DIVINE's table on information about comorbidities}
\format{
A data frame with 5813 rows and 37 columns
\describe{
\item{record_id:}{Identifier of each record. This information does not match the real data.}
\item{covid_wave:}{A factor with levels \verb{Wave 1}, \verb{Wave 2}, \verb{Wave 3}, and \verb{Wave 5}. COVID-19 wave.}
\item{center:}{A factor with levels \verb{Hospital A}, \verb{Hospital B}, \verb{Hospital C}, \verb{Hospital D}, and \verb{Hospital E}. Center of admission}
\item{sociofunctional:}{A factor with levels \verb{Lives with a spouse of similar age}, \verb{Lives with a spouse with some degree of dependency}, \verb{Lives with a non-family caregiver}, \verb{Lives with family. The caregiver is not their spouse}, \verb{Lives with family without physical dependency}, \verb{Lives alone and has no children or they are far away}, \verb{Lives alone and has nearby children}. Sociofunctional status}
\item{frailty:}{A factor with levels \code{No}, \code{PCC} and \code{MACA}. Is the patient a chronic complex patient (PCC) or a patient with advanced chronic disease (MACA)?}
\item{barthel_score:}{Punctuation in the Barthel scale used to measure performance in activities of daily living}
\item{weight:}{Weight (kg)}
\item{height:}{Height (cm)}
\item{body_mass_index:}{Body mass index computed as \eqn{\frac{\mbox{weight (kg)}}{\mbox{height (m)}^2}}}
\item{dm:}{A factor with levels \code{No} and \code{Yes}. Diabetes mellitus Type 2}
\item{type_dm:}{A factor with levels \verb{With target organ involvement} and \verb{Without complications}. For patients with diabetes mellitus type 2, type of disease}
\item{chronic_lung_disease:}{A factor with levels \code{No} and \code{Yes}. Chronic lung disease (including COPD, asthma and obstructive sleep apnea, among others)}
\item{chronic_kidney_disease:}{A factor with levels \code{No} and \code{Yes}. Severe chronic kidney disease}
\item{mild_kidney_disease:}{A factor with levels \code{No} and \code{Yes}. Mild kidney disease}
\item{renal_therapy:}{A factor with levels \code{No} and \code{Yes}. Is the patient currently receiving renal replacement therapy?}
\item{heart_disease:}{A factor with levels \code{No} and \code{Yes}. Heart failure}
\item{coronary_disease:}{A factor with levels \code{No} and \code{Yes}. Coronary heart disease}
\item{myocardial_infarction:}{A factor with levels \code{No} and \code{Yes}. Has the patient ever had a heart attack?}
\item{hematologic_neo:}{A factor with levels \code{No} and \code{Yes}. Haematological neoplasia}
\item{hematologic_neo_type:}{A factor with levels \code{Leukemia}, \code{Lymphoma} and \code{Myeloma}. For patients with Haematological neoplasia, type of disease.}
\item{non_metastatic_neo:}{A factor with levels \code{No} and \code{Yes}. Non-Metastatic Neoplasia}
\item{metastatic_neo:}{A factor with levels \code{No} and \code{Yes}. Metastatic Neoplasia}
\item{stroke_tia:}{A factor with levels \code{No} and \code{Yes}. Has the patient ever had a stroke or a transient ischemic attack?}
\item{peripheral_vasculopathy:}{A factor with levels \code{No} and \code{Yes}. Peripheral artery disease}
\item{dementia:}{A factor with levels \code{No} and \code{Yes}. Dementia}
\item{mild_liver_disease:}{A factor with levels \code{No} and \code{Yes}. Mild liver disease}
\item{severe_liver_disease:}{A factor with levels \code{No} and \code{Yes}. Severe liver disease}
\item{connective_tissue_disease:}{A factor with levels \code{No} and \code{Yes}. Connective tissue disease}
\item{peptic_ulcer:}{A factor with levels \code{No} and \code{Yes}. Peptic ulcer}
\item{hemiplegia:}{A factor with levels \code{No} and \code{Yes}. Hemiplegia}
\item{hiv:}{A factor with levels \code{No} and \code{Yes}. Human immunodeficiency virus}
\item{charlson_index:}{Value of the Charlson Comorbidity Index. This index predicts the ten-year mortality for a patient given the information of their comorbid conditions}
\item{hypertension:}{A factor with levels \code{No} and \code{Yes}. Hypertension}
\item{dyslipidemia:}{A factor with levels \code{No} and \code{Yes}. Dyslipidemia }
\item{depression:}{A factor with levels \code{No} and \code{Yes}. Depression}
\item{ceiling:}{A factor with levels \verb{Oxygen mask} (non-rebreather oxygen mask), \verb{HFNC or NIMV} (high-flow nasal cannula or non-invasive mechanical ventilation) and \verb{IMV and ICU admission} (invasive mechanical ventilation and acces to intensive care unit). Therapeutic ceiling of care assigned to the patient}
\item{ceiling_dico:}{A factor with the dichotomization of the variable ceiling in two levels \code{No} (\verb{IMV and ICU admission}) and \code{Yes} (\verb{Oxygen mask} and \verb{HFNC or NIMV})}
}
}
\usage{
data(comorbidities)
}
\description{
Information about comorbidities of patients included in the DIVINE cohort. Data was collected at hospital admission.
}
\references{
Pallarès, N., Tebé, C., Abelenda-Alonso, G., Rombauts, A., Oriol, I., Simonetti, A. F., Rodríguez-Molinero, A., Izquierdo, E., Díaz-Brito, V., Molist, G., Gómez Melis, G., Carratalà, J., Videla, S., & MetroSud and Divine study groups (2023). Characteristics and Outcomes by Ceiling of Care of Subjects Hospitalized with COVID-19 During Four Waves of the Pandemic in a Metropolitan Area: A Multicenter Cohort Study. Infectious diseases and therapy, 12(1), 273–289. https://doi.org/10.1007/s40121-022-00705-w
}
\keyword{datasets}
