\name{DRrank}
\alias{DRrank}
\title{ Ranking Regulators }
\description{
  The algorithm to rank candidate regulators
}
\usage{
DRrank(exprs, exprs.1, exprs.2,
	tf, tf2target, exprs_design,
	p.value, DRsort.res,
	Permutation_Times=0)
}
\arguments{
  \item{exprs}{a data frame or matrix for expression dataset, with rows as variables (genes) and columns as samples.}
  \item{exprs.1}{a data frame or matrix for condition A, with rows as variables (genes) and columns as samples.}
  \item{exprs.2}{a data frame or matrix for condition B, with rows as variables (genes) and columns as samples.}
  \item{tf}{A data frame with 215 TFs.}
  \item{tf2target}{a data frame or matrix for regulator-to-target interaction pairs.}
  \item{exprs_design}{a data frame or matrix for displaying microarray experiment design.}
  \item{p.value}{ a p value threshold to determine differential expression genes (DEGs).}
  \item{DRsort.res}{a list generated by DRsort function, with six components which are DCGs, DCLs, DRGs, DRLs DCG2TF and TF_briged_DCL.}
  \item{Permutation_Times}{permutation times. If Permutation_Times>0, the permutation step will be implemented for TED and TDD methods. The default value for Permutation_Times is 0.}
}
\details{
DRrank is implemented for ranking potential TFs in terms of their relevance to the phenotypic change or biophysical process of interest. It 
contains three methods: RIF (Reverter etal. 2010), TED, and TDD. The latter two methods were proposed by us firstly in this package.

TED, short for 'Target Enrichment Density', employs Binomial Probability model to quantify the enrichment of a TF's targets in the DCG set, 
and as such to evaluate which regulators are more likely to be subject-relevant or even causal. Suppose we sift K DCGs from expression profile 
which contains N genes. If TFi has Ti targets in regulation knowledge, there should be Ti * K / N DCGs appeared in TFi targets 
list randomly. Actually, it is found that TI DCGs are included in TFi's targets list. The larger TI than Ti * K / N is, the more 
targets of TFi enriched, the more likely TFi is a relevant or causative regulator.


TDD, short for 'Targets' DCL Density', uses Clustering Coefficient to quantify the density of DCLs among a regulator's targets, and so to judge 
the importance of a TF. Suppose that TFi has n targets, and that there are k DCLs among these targets. A larger k means more DCLs are 
bridged by the common TFi. We intuitively assume that, if a TF bridged more TF_bridged_DCL it is of more importance (even if the regulator 
is not a DCG).

RIF method, short for 'Regulator Impact Factor', assesses the change of regulation-accountable expression value of Differentially Expressed 
Genes (DEGs) and correlation coefficient between DEGs and TFs.


}
\value{
  A matrix to display TED, TDD and RIF scores and ranks.
}
\references{
Reverter, A., Hudson, N. J., Nagaraj, S. H., Perez-Enciso, M., Dalrymple, B. P., (2010) Regulatory impact factors: unraveling the transcriptional regulation of complex traits from expression data, 26, 896-904.
}
\author{Jing Yang, Hui Yu}

\keyword{ Regulator Rank }

\examples{
data(exprs)
## divide exprs into two parts corresponding to condition 1 
## (exprs.1) and condition 2 (exprs.2) respectively
exprs<-exprs[1:100,]
exprs.1<-exprs[1:100,1:16]
exprs.2<-exprs[1:100,17:63]

data(tf2target)
data(tf)
data(exprs_design)
DCp.res<-DCp(exprs.1,exprs.2,
	link.method = 'qth',cutoff=0.25)
DCe.res<-DCe(exprs.1,exprs.2,
	link.method = 'qth',cutoff=0.25,nbins=10,p=0.1)
DCsum.res<-DCsum(DCp.res,DCe.res,DCpcutoff=0.25,DCecutoff=0.4)
\donttest{DRsort.res<-DRsort(DCsum.res$DCGs,DCsum.res$DCLs,tf2target,exprs)}

## rank all the potential TFs
\donttest{DRrank.res<-DRrank(exprs,exprs.1,exprs.2,
	tf,tf2target,exprs_design,
	p.value=0.05,DRsort.res,
	Permutation_Times=0)
}
\donttest{DRrank.res[1:3,]}
}