% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_variable_dropout.R
\name{plot.variable_dropout_explainer}
\alias{plot.variable_dropout_explainer}
\title{Plots Global Model Explanations (Variable Drop-out)}
\usage{
\method{plot}{variable_dropout_explainer}(x, ..., max_vars = 10)
}
\arguments{
\item{x}{a variable fropout exlainer produced with the 'variable_dropout' function}

\item{...}{other explainers that shall be plotted together}

\item{max_vars}{maximum number of variables that shall be presented for for each model}
}
\value{
a ggplot2 object
}
\description{
Function \code{plot.variable_dropout_explainer} plots dropouts for variables used in the model.
It uses output from \code{variable_dropout} function that corresponds to permutation based measure of variable importance.
}
\examples{

\dontrun{
library("breakDown")
library("randomForest")
HR_rf_model <- randomForest(left~., data = breakDown::HR_data, ntree = 100)
explainer_rf  <- explain(HR_rf_model, data = HR_data, y = HR_data$left)
vd_rf <- variable_dropout(explainer_rf, type = "raw")
vd_rf
plot(vd_rf)

HR_glm_model <- glm(left~., data = breakDown::HR_data, family = "binomial")
explainer_glm <- explain(HR_glm_model, data = HR_data, y = HR_data$left)
logit <- function(x) exp(x)/(1+exp(x))
vd_glm <- variable_dropout(explainer_glm, type = "raw",
                        loss_function = function(observed, predicted)
                                   sum((observed - logit(predicted))^2))
vd_glm
plot(vd_glm)

library("xgboost")
model_martix_train <- model.matrix(left~.-1, breakDown::HR_data)
data_train <- xgb.DMatrix(model_martix_train, label = breakDown::HR_data$left)
param <- list(max_depth = 2, eta = 1, silent = 1, nthread = 2,
              objective = "binary:logistic", eval_metric = "auc")
HR_xgb_model <- xgb.train(param, data_train, nrounds = 50)
explainer_xgb <- explain(HR_xgb_model, data = model_martix_train,
                                    y = HR_data$left, label = "xgboost")
vd_xgb <- variable_dropout(explainer_xgb, type = "raw")
vd_xgb
plot(vd_xgb)

plot(vd_rf, vd_glm, vd_xgb)

# NOTE:
# if you like to have all importances hooked to 0, you can do this as well
vd_rf <- variable_dropout(explainer_rf, type = "difference")
vd_glm <- variable_dropout(explainer_glm, type = "difference",
                        loss_function = function(observed, predicted)
                                   sum((observed - logit(predicted))^2))
vd_xgb <- variable_dropout(explainer_xgb, type = "difference")
plot(vd_rf, vd_glm, vd_xgb)
}

}
