% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.Kappa.R
\name{Kappa}
\alias{Kappa}
\title{Computes the Kappa Cohen value.}
\description{
Cohen's Kappa measures the agreement between two raters who each
classify N items into C mutually exclusive categories.
}
\details{
\deqn{\kappa \hspace{0.1cm} is \hspace{0.1cm} equivalent
\hspace{0.1cm} to \hspace{0.1cm} (p_o - p_e) / (1 - p_e) = 1 - (1 - p_0) /
(1 - p_e)}
}
\seealso{
\code{\link{MeasureFunction}}, \code{\link{ClassificationOutput}},
\code{\link{ConfMatrix}}
}
\keyword{classif}
\keyword{math}
\section{Super class}{
\code{\link[D2MCS:MeasureFunction]{D2MCS::MeasureFunction}} -> \code{Kappa}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Kappa$new()}}
\item \href{#method-compute}{\code{Kappa$compute()}}
\item \href{#method-clone}{\code{Kappa$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kappa$new(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} used as
basis to compute the performance.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-compute"></a>}}
\if{latex}{\out{\hypertarget{method-compute}{}}}
\subsection{Method \code{compute()}}{
The function computes the \strong{Kappa} achieved by the M.L.
model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kappa$compute(performance.output = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{performance.output}}{An optional \code{\link{ConfMatrix}} parameter
to define the type of object used as basis to compute the \code{Kappa}
measure.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function is automatically invoked by the
\link{ClassificationOutput} object.
}

\subsection{Returns}{
A \link{numeric} vector of size 1 or \link{NULL} if an error
occurred.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Kappa$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
