% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCDLData.R
\name{GetCDLData}
\alias{GetCDLData}
\title{Request for the CDL raster data}
\usage{
GetCDLData(
  aoi = NULL,
  year = NULL,
  type = NULL,
  mat = FALSE,
  crs = NULL,
  tol_time = 20
)
}
\arguments{
\item{aoi}{Area of interest. Could be a 5-digit FIPS code of a county, three coordinates that defines a triangle area,
four corner points that defines a rectangle (or a box) area, or a single coordinate. See details.}

\item{year}{Year of data. Should be a 4-digit numerical value.}

\item{type}{Type of the selected AOI. 'f' for county, 'ps' for triangle area, 'b' for box area, 'p' for a single coordinate.}

\item{mat}{TRUE/FALSE. If TRUE, return a data table. If FALSE (default), return a raster tif file.}

\item{crs}{Coordinate system. NULL if use the default coordinate system (i.e., Albers projection); Use '+init=epsg:4326' for longitude/latitude.}

\item{tol_time}{Number of seconds to wait for a response until giving up. Default is 20 seconds.}
}
\value{
The function returns a raster TIF file or a data table that saves the cropland cover information. There are three columns in the returned data table. The first two are
coordinates. The third column reports numerical codes of the land cover category. The CDL provides an EXCEL file that links the numerical codes
with the land cover names. Users can download the EXCEL file from this link \url{https://www.nass.usda.gov/Research_and_Science/Cropland/docs/cdl_codes_names.xlsx}.
Users can also use \code{data(linkdata)} to get those data directly from this package.
Yet, be noted that the linkdata saved in this package is not frequently updated.
}
\description{
A function that makes HTTP GET requests for CDL raster data for any Area of Interests (AOI) in a given year.
This function implements the GetCDLData service provided by the CropScape \url{https://nassgeodata.gmu.edu/CropScape}.
}
\details{
An AOI can be a county defined by a 5-digit FIPS code, a triangle area (defined by three coordinates),
a rectangle/box (defined by four corner points), or a single point (defined by a coordinate). When using coordinates,
be noted that the default coordinate system used by the CDL is a projected
coordinate system called Albers projection (or Albers equal-area conic projection). Users could specify coordinates based on a
different coordinate system (defined by the \code{crs} argument), including the geographic coordinate system such as latitude/longitude.

When requesting data for a triangle area, users are expected to provide a vector with six
numerical values (representing three coordinates) as an input for AOI.
For instance, if latitude/longitude is used, users should specify the AOI as
(longitude 1, latitude 1, longitude 2, latitude 2, longitude 3, latitude 3).
When requesting data for a box area, users are expected to provided a vector with four
numerical values (representing corner points of the box) as an input for AOI.
For instance, if latitude/longitude is used, users should specify the AOI as
(Lower longitude, Lower latitude, Higher longitude, Higher latitude). See examples.

The \code{tol_time} argument specifies the time limit for making the HTTP GET request. This is useful particularly when the CropScape server has an issue with processing the data.
CropScape could sometime take minutes before returning an error saying that the requested data are not available. By setting a time limit, the \code{GetCDLComp} function would stop
making the data requests when the time limit is reached. The default time limit is 20 seconds.
}
\examples{
\donttest{
# Example. Retrieve data for the Champaign county in Illinois (FIPS = 17109) in 2018.
data <- GetCDLData(aoi = 17019, year = 2018, type = 'f')
raster::plot(data) # plot the data.

# Example. Retrieve data for a single point by long/lat in 2018.
data <- GetCDLData(aoi = c(-94.6754,42.1197), year = 2018, type = 'p', crs = '+init=epsg:4326')
data
# Below uses the same point, but under the default coordinate system
data <- GetCDLData(aoi = c(108777,2125055), year = 2018, type = 'p')
data

# Example. Retrieve data for a triangle area defined by three coordinates in 2018.
data <- GetCDLData(aoi = c(175207,2219600,175207,2235525,213693,2219600), year = 2018, type = 'ps')
raster::plot(data)

# Example. Retrieve data for a box area defined by four corner points in 2018.
data <- GetCDLData(aoi = c(130783,2203171,153923,2217961), year = '2018', type = 'b')
raster::plot(data)

# Example. Retrieve data for a box area defined by four corner points (long/lat)
data <- GetCDLData(aoi = c(-88.2, 40.03, -88.1, 40.1), year = '2018', type = 'b',
crs = '+init=epsg:4326')
raster::plot(data)
}
}
