% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot.conData.R
\name{barplot.conData}
\alias{barplot.conData}
\title{Depict the relative frequencies (and conditional probabilities) of a binary time series in a barplot}
\usage{
\method{barplot}{conData}(height, plottype = "RelFreq", color = NULL, legend = TRUE, ...)
}
\arguments{
\item{height}{conData object}

\item{plottype}{needs to be specified
if 'RelFreq' only the relative frequency is depicted
if 'All' both the relative frequency and the conditional probabilities are depicted}

\item{color}{string of chars contanig as many colornames as variables in the object (default='gray')}

\item{legend}{indicates whether you want to include a legend or not}

\item{...}{parameters to be passed on to barplot}
}
\value{
barplot
}
\description{
Depict the relative frequencies (and conditional probabilities) of a binary time series in a barplot
}
\examples{
ExampleData <- cbind(rep(c(0,1),100),
                     rep(c(0,0,0,0,0,1,1,1,1,1),20),
                     c(rep(c(0,0,0,1,1),20),rep(c(0,1,1,1,1),20)),
                     ifelse(rnorm(200,0,1)<0.95,1,0),
                     c(ifelse(rnorm(100,0,1)<0.7,1,0),ifelse(rnorm(100,0,1)<0.7,0,1)),
                     ifelse(rnorm(200,0,1)<(-0.98),1,0))
 colnames(ExampleData) <- c('Var 1','Var 2','Var 3',
                            'Var 4','Var 5','Var 6')
 fancy.col <- c('purple','slateblue','royalblue','cyan4',
                'green3','olivedrab3')
 PersData <- conData(ExampleData)
 barplot(PersData, plottype='RelFreq', color=fancy.col)
 barplot(PersData, plottype='All', color=fancy.col)

 data(SymptomData)
 Sdata <- conData(SymptomData)
 FANCY= c('purple','slateblue', 'royalblue', 'cyan4', 'green3',
          'olivedrab3', 	'orange', 'orangered')
 barplot(Sdata,plottype='RelFreq', color = FANCY)
}
