% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalibrateSSB.R
\encoding{UTF8}
\name{CalibrateSSB}
\alias{CalibrateSSB}
\title{Calibration weighting and estimation}
\usage{
CalibrateSSB(grossSample, calmodel = NULL, response = "R",
  popTotals = NULL, y = NULL, by = NULL, partition = NULL,
  lRegmodel = NULL, popData = NULL, samplingWeights = NULL,
  usePackage = "survey", bounds = c(-Inf, Inf), calfun = "linear",
  onlyTotals = FALSE, onlyw = FALSE, uselRegWeights = FALSE,
  ids = NULL, residOutput = TRUE, leverageOutput = FALSE,
  yOutput = TRUE, samplingWeightsOutput = FALSE, dropResid2 = TRUE,
  wGrossOutput = TRUE, wave = NULL, id = NULL, extra = NULL,
  allowNApopTotals = NULL, partitionPrint = NULL, ...)
}
\arguments{
\item{grossSample}{Data frame.}

\item{calmodel}{Formula defining the linear structure of the calibration
model.}

\item{response}{Variable name of response indicator (net sample when 1).}

\item{popTotals}{Population totals (similar to population totals as output).}

\item{y}{Names of variables of interest. Can be a list similar to "by"
below.}

\item{by}{Names of the variables that define the "estimation domains". If
NULL (the default option) or NA estimates refer to the whole population. Use
list for multiple specifications (resulting in list as output).}

\item{partition}{Names of the variables that define the "calibration
domains" for the model. NULL (the default) implies no calibration domains.}

\item{lRegmodel}{Formula defining the linear structure of a logistic
regression model.}

\item{popData}{Data frame of population data.}

\item{samplingWeights}{Name of the variable with initial weights for the
sampling units.}

\item{usePackage}{Specifying the package to be used: "survey" (the default),
"ReGenesees" or "none".}

\item{bounds}{Bounds for the calibration weights. When ReGenesees: Allowed
range for the ratios between calibrated and initial weights. The default is
c(-Inf,Inf).}

\item{calfun}{The distance function for the calibration process; the default
is 'linear'.}

\item{onlyTotals}{When TRUE: Only population totals are returned.}

\item{onlyw}{When TRUE: Only the calibrated weights are returned.}

\item{uselRegWeights}{When TRUE: Weighted logistic regression is performed
as a first calibration step.}

\item{ids}{Name of sampling unit identifier variable.}

\item{residOutput}{Residuals in output when TRUE. FALSE is default.}

\item{leverageOutput}{Leverages in output when TRUE. FALSE is default.}

\item{yOutput}{y in output when TRUE. FALSE is default.}

\item{samplingWeightsOutput}{samplingWeights in output when TRUE. FALSE is
default.}

\item{dropResid2}{When TRUE (default) and when no missing population totals
- only one set of residuals in output.}

\item{wGrossOutput}{wGross in output when TRUE (default) and when NA
popTotals.}

\item{wave}{Time or another repeat variable (to be included in output).}

\item{id}{Identifier variable (to be included in output).}

\item{extra}{Variables for the extra dataset (to be included in output).}

\item{allowNApopTotals}{When TRUE missing population totals are allowed.
Results in error when FALSE and warning when NULL.}

\item{partitionPrint}{When TRUE partition progress is printed. 
Automatic decision when NULL (about 1 min total computing time).}

\item{...}{Further arguments sent to underlying functions.}
}
\value{
Unless onlyTotals or onlyw is TRUE, the output is an object of class calSSB. That is, a list with 
elements: \item{popTotals}{Population totals.} \item{w}{The calibrated
weights.} \item{wGross}{Calibrated gross sample weights when NA popTotals.}
\item{estTM}{Estimates (with standard error).} \item{resids}{Residuals,
reduced model when NA popTotals.} \item{resids2}{Residuals, full model.}
\item{leverages}{Diagonal elements of hat-matrix, reduced model when NA
popTotals.} \item{leverages2}{Diagonal elements of hat-matrix, full model.}
\item{y}{as input} \item{samplingWeights}{as input}
\item{wave}{as input or via CrossStrata}
\item{id}{as input}
\item{extra}{as input}
}
\description{
Compute weights by calibration and corresponding estimates, totals and
residuals
}
\details{
When popTotals as input is NULL, population totals are computed from popData
(when available) or from grossSample. Some elements of popTotals may be
missing (not allowed when using ReGenesees). When using "ReGenesees", both
weiging and estimation are done by that package. When using "survey", only
calibration weiging are done by that package.
The parameters \code{wave}, \code{id} and \code{extra} have no effect on the 
computations, but result in extra elements in output 
(to be used by WideFromCalibrate() later).
}
\examples{

# Generates data  - two years
z    <- AkuData(3000)  # 3000 in each quarter
zPop <- AkuData(10000)[,1:7]

# Calibration using "survey"
a <- CalibrateSSB(z, calmodel = "~ sex*age",
                 partition = c("year","q"),  # calibrate within quarter
                 popData = zPop, y = c("unemployed","workforce"),
                 by = c("year","q")) # Estimate within quarter
head(a$w) # calibrated weights
a$estTM   # estimates
a$popTotals   # popTotals used as input below


# Calibration, no package, popTotals as input
b <- CalibrateSSB(z, popTotals=a$popTotals, calmodel="~ sex*age",
      partition = c("year","q"), usePackage = "none", y = c("unemployed","workforce"))
max(abs(a$w-b$w)) # Same weights as above

print(a)
print(b)


}
\seealso{
\code{\link{CalSSBobj}}, \code{\link{WideFromCalibrate}},  \code{\link{PanelEstimation}}, \code{\link{CalibrateSSBpanel}}.
}
