% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varcovcubpq.R
\name{varcovcubpq}
\alias{varcovcubpq}
\title{Variance-covariance matrix of a CUB model with covariates for both uncertainty and feeling}
\usage{
varcovcubpq(m, ordinal, Y, W, bet, gama)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of covariates for explaining the uncertainty parameter}

\item{W}{Matrix of covariates for explaining the feeling parameter}

\item{bet}{Vector of parameters for the uncertainty component, with length equal to
NCOL(Y)+1 to account for an intercept term (first entry)}

\item{gama}{Vector of parameters for the feeling component, with length equal to
NCOL(W)+1 to account for an intercept term (first entry)}
}
\description{
Compute the variance-covariance matrix of parameter estimates of a CUB model with covariates for
 both the uncertainty and the feeling components.
}
\details{
The function checks if the variance-covariance matrix is positive-definite: if not, it returns a warning
 message and produces a matrix with NA entries.
}
\references{
Piccolo D. (2006), Observed Information Matrix for CUB Models, \emph{Quaderni di Statistica}, \bold{8}, 33--78
}
\seealso{
\code{\link{probcubpq}}
}
\keyword{internal}
