% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inibestcubecov.R
\name{inibestcubecov}
\alias{inibestcubecov}
\title{Preliminary parameter estimates for CUBE models with covariates}
\usage{
inibestcubecov(m,ordinal,Y,W,Z)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{Y}{Matrix of selected covariates to explain the uncertainty parameter}

\item{W}{Matrix of selected covariates to explain the feeling parameter}

\item{Z}{Matrix of selected covariates to explain the overdispersion parameter}
}
\value{
A vector \code{(inibet, inigama, inialpha)} of preliminary estimates of parameter vectors for 
 \eqn{\pi = \pi(\bold{\beta})}, \eqn{\xi=\xi(\bold{\gamma})}, \eqn{\phi=\phi(\bold{\alpha})}, respectively, of a CUBE model with covariates for all the three
  parameters. In details, \code{inibet}, \code{inigama} and \code{inialpha} have length equal to NCOL(Y)+1, NCOL(W)+1 and
  NCOL(Z)+1, respectively, to account for an intercept term for each component.
}
\description{
Compute preliminary parameter estimates for a CUBE model with covariates for all the three parameters. 
These estimates are set as initial values to start the E-M algorithm within maximum likelihood estimation.
}
\examples{
data(relgoods)
m<-10 
naord<-which(is.na(relgoods$Tv))
nacovpai<-which(is.na(relgoods$Gender))
nacovcsi<-which(is.na(relgoods$year.12))
nacovphi<-which(is.na(relgoods$EducationDegree))
na<-union(union(naord,nacovpai),union(nacovcsi,nacovphi))
ordinal<-relgoods$Tv[-na]
Y<-relgoods$Gender[-na]
W<-relgoods$year.12[-na]
Z<-relgoods$EducationDegree[-na]
ini<-inibestcubecov(m,ordinal,Y,W,Z)
p<-NCOL(Y)
q<-NCOL(W)
inibet<-ini[1:(p+1)]               # Preliminary estimates for uncertainty 
inigama<-ini[(p+2):(p+q+2)]        # Preliminary estimates for feeling 
inialpha<-ini[(p+q+3):length(ini)] # Preliminary estimates for overdispersion
}
\seealso{
\code{\link{inibestcube}}, \code{\link{inibestcubecsi}}, \code{\link{inibestgama}}
}
\keyword{htest}
\keyword{utilities}
