% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcessLinRegMatrix.R
\name{postProcessLinRegMatrix}
\alias{postProcessLinRegMatrix}
\title{Postprocess linear regression matrix.}
\usage{
postProcessLinRegMatrix(input_matrix, LM_mat, cor_type = "pearson",
  inf_replacement_val = 300)
}
\arguments{
\item{input_matrix}{The input matrix, which consists of bins and samples (no LM or correlation has been done on the segmentation values)}

\item{LM_mat}{The linear regression matrix, with rows and columns consisting of bins and the values being the negative log p-value between them.}

\item{cor_type}{The correlation type ("pearson" (linear), "spearman" (rank), "kendall"(also rank-based)).
Rank correlations capture nonlinear relationships as well as linear. Passed to stats::cor's method parameter.}

\item{inf_replacement_val}{the value for which infinites are replaced, by default 300.}
}
\value{
The output matrix, or if using slurm, the slurm job object (which should be saved as an rds file and reloaded when creating the output matrix).
}
\description{
Takes a linear regression matrix and sets infinites to a finite value, and changes the sign to match the sign of the correlation for each value.
}
\examples{
inputmat<-matrix(runif(15),nrow=3)
colnames(inputmat)<-c("chr2_1_1000","chr2_1001_2000","chr2_2001_3000","chr2_3001_4000",
"chr2_4001_5000")
rownames(inputmat)<-c("PAFPJK","PAKKAT","PUFFUM")
outputmat<-matrix(runif(15),nrow=3)
outputmat<-cor(inputmat)*matrix(runif(25,-30,500),nrow=5)
diag(outputmat)<-Inf
postProcessLinRegMatrix(input_matrix=t(inputmat),LM_mat=outputmat,cor_type="pearson",
inf_replacement_val=300)
}
\keyword{correlation}
\keyword{linear}
\keyword{lm}
\keyword{matrix}
\keyword{regression}
