% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSelection.R
\name{SequentialScree}
\alias{SequentialScree}
\title{Sequential Model Selection for Multiple CICA model}
\usage{
SequentialScree(x)
}
\arguments{
\item{x}{an object of class MultipleCICA}
}
\value{
a list object
}
\description{
Sequential Model Selection for Multiple CICA model
}
\examples{
\dontrun{
CICA_data <- Sim_CICA(Nr = 15, Q = 5, R = 4, voxels = 100, timepoints = 10,
E = 0.4, overlap = .25, externalscore = TRUE)

multiple_output = CICA(DataList = CICA_data$X, nComp = 2:6, nClus = 1:5,
userGrid = NULL, RanStarts = 30, RatStarts = NULL, pseudo = c(0.1, 0.2),
pseudoFac = 2, userDef = NULL, scalevalue = 1000, center = TRUE,
maxiter = 100, verbose = TRUE, ctol = .000001)

ModSelOutput <- SequentialScree(multiple_output)

plot(ModSelOutput)
}

}
