% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_SSRUs}
\alias{load_SSRUs}
\title{Load CCAMLR Small Scale Research Units}
\usage{
load_SSRUs()
}
\description{
Download the up-to-date spatial layer from the online CCAMLRGIS (\url{http://gis.ccamlr.org/}) and load it to your environment.
See examples for offline use. All layers use the Lambert azimuthal equal-area projection
 (\code{\link{CCAMLRp}})
}
\examples{
 
\donttest{

#When online:
SSRUs=load_SSRUs()
plot(st_geometry(SSRUs))

#If going offline in the future: load and save as RData when online,
#then reload RData when offline:
SSRUs=load_SSRUs()
EEZs=load_EEZs()
#N.B.: replace tempdir() with folder location of your choice
save(list=c('SSRUs','EEZs'), file = file.path(tempdir(), "CCAMLRLayers.RData"))
rm(SSRUs,EEZs)
load(file.path(tempdir(), "CCAMLRLayers.RData"))

}

}
\seealso{
\code{\link{load_ASDs}}, \code{\link{load_RBs}},
\code{\link{load_SSMUs}}, \code{\link{load_MAs}}, \code{\link{load_Coastline}},
\code{\link{load_MPAs}}, \code{\link{load_EEZs}}.
}
