% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_ASDs}
\alias{load_ASDs}
\title{Load CCAMLR statistical Areas, Subareas and Divisions}
\usage{
load_ASDs()
}
\description{
Download the up-to-date spatial layer from the \href{http://gis.ccamlr.org/}{online CCAMLRGIS} and load it to your environment.
The layer's Metadata is accessible by clicking on the red 'i' in the list of layers available on the \href{http://gis.ccamlr.org/}{online CCAMLRGIS}.
See examples for offline use.
}
\examples{
 
\donttest{

#When online:
ASDs=load_ASDs()
plot(ASDs)

#If going offline in the future: load and save as RData when online,
# then reload RData when offline:
ASDs=load_ASDs()
EEZs=load_EEZs()
save(list=c('ASDs','EEZs'), file = file.path(tempdir(), "CCAMLRLayers.RData"))
rm(ASDs,EEZs)
load(file.path(tempdir(), "CCAMLRLayers.RData"))

}
}
\seealso{
\code{\link{load_SSRUs}}, \code{\link{load_RBs}},
\code{\link{load_SSMUs}}, \code{\link{load_MAs}}, \code{\link{load_Coastline}},
\code{\link{load_RefAreas}}, \code{\link{load_MPAs}}, \code{\link{load_EEZs}}.
}
