% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npCBPS.R
\name{npCBPS.fit}
\alias{npCBPS.fit}
\title{npCBPS.fit}
\usage{
npCBPS.fit(treat, X, corprior, print.level, ...)
}
\arguments{
\item{treat}{A vector of treatment assignments.  Binary or multi-valued
treatments should be factors.  Continuous treatments should be numeric.}

\item{X}{A covariate matrix.}

\item{corprior}{Prior hyperparameter controlling the expected amount of
correlation between each covariate and the treatment. Specifically, the
amount of correlation between the k-dimensional covariates, X, and the
treatment T after weighting is assumed to have prior distribution
MVN(0,sigma^2 I_k). We conceptualize sigma^2 as a tuning parameter to be
used pragmatically. It's default of 0.1 ensures that the balance constraints
are not too harsh, and that a solution is likely to exist. Once the
algorithm works at such a high value of sigma^2, the user may wish to
attempt values closer to 0 to get finer balance.}

\item{print.level}{Controls verbosity of output to the screen while npCBPS
runs. At the default of print.level=0, little output is produced. It
print.level>0, it outputs diagnostics including the log posterior
(log_post), the log empirical likelihood associated with the weights
(log_el), and the log prior probability of the (weighted) correlation of
treatment with the covariates.}

\item{...}{Other parameters to be passed.}
}
\description{
npCBPS.fit
}
