% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_observations.R
\name{get_observations}
\alias{get_observations}
\title{Run an algorithm on a problem.}
\usage{
get_observations(algo, instance, n = 1)
}
\arguments{
\item{algo}{a list object containing the definitions of the algorithm.
See \code{\link[=calc_nreps]{calc_nreps()}} for details.}

\item{instance}{a list object containing the definitions of the problem
instance. See \code{\link[=calc_nreps]{calc_nreps()}} for details.}

\item{n}{number of observations to generate.}
}
\value{
vector of observed performance values
}
\description{
Call algorithm routine for the solution of a problem instance
}
\examples{
# Make a dummy instance with a centered (zero-mean) exponential distribution:
instance <- list(FUN = "dummyinstance", distr = "rexp", rate = 5, bias = -1/5)

# Simulate a dummy algorithm that has a uniform distribution of expected
# performance values, between -25 and 50.
algorithm <- list(FUN = "dummyalgo",
                 distribution.fun = "runif",
                 distribution.pars = list(min = -25, max = 50))
x <- get_observations(algorithm, instance, n = 1000)
hist(x)
}
\seealso{
\code{\link[=calc_nreps]{calc_nreps()}}
}
\author{
Felipe Campelo (\email{fcampelo@ufmg.br},
\email{f.campelo@aston.ac.uk})
}
