% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuysePower-summary.R
\docType{methods}
\name{S4BuysePower-summary}
\alias{S4BuysePower-summary}
\alias{summary,S4BuysePower-method}
\title{Summary Method for Class "S4BuysePower"}
\usage{
\S4method{summary}{S4BuysePower}(
  object,
  statistic = NULL,
  endpoint = NULL,
  order.Hprojection = NULL,
  transformation = NULL,
  print = TRUE,
  legend = TRUE,
  col.rep = FALSE,
  digit = 4,
  ...
)
}
\arguments{
\item{object}{output of \code{\link{powerBuyseTest}}}

\item{statistic}{[character] the statistic summarizing the pairwise comparison: \code{"netBenefit"}, \code{"winRatio"}, \code{"favorable"}, \code{"unfavorable"}.
See the documentation of the \code{coef} method for further details.
Default value read from \code{BuyseTest.options()}.}

\item{endpoint}{[character vector] the endpoints to be displayed: must be the name of the endpoint followed by an underscore and then by the threshold.}

\item{order.Hprojection}{[integer 1,2] the order of the H-project to be used to compute the variance of the net benefit/win ratio.}

\item{transformation}{[logical] should the CI be computed on the logit scale / log scale for the net benefit / win ratio and backtransformed.}

\item{print}{[logical] Should the table be displayed?.}

\item{legend}{[logical] should explainations about the content of each column be displayed?}

\item{col.rep}{[logical] should the number of successful simulations be displayed?}

\item{digit}{[integer vector] the number of digit to use for printing the counts and the delta.}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
data.frame
}
\description{
Summarize the results from the \code{\link{powerBuyseTest}} function.
}
\seealso{
\code{\link{powerBuyseTest}} for performing a simulation study for generalized pairwise comparison. \cr
}
\author{
Brice Ozenne
}
\keyword{print}
