% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radiation_parameters.R
\name{rns_calculation}
\alias{rns_calculation}
\title{Net solar or net shortwave radiation (rns)}
\usage{
rns_calculation(albedo, rs)
}
\arguments{
\item{albedo}{Albedo or canopy reflectance coefficient. The 0.23 is the value used for hypothetical grass reference crop (dimensionless).}

\item{rs}{The incoming solar radiation (MJ m-2 day-1).}
}
\value{
A data.frame object with the net solar or net shortwave radiation data.
}
\description{
The rns results form the balance between incoming and reflected solar radiation (MJ m-2 day-1).
}
\examples{
\dontrun{
ra <- rns_calculation(albedo, rs)
}
}
\author{
Roberto Filgueiras, Luan P. Venancio, Catariny C. Aleman and Fernando F. da Cunha
}
