% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performanceassess.R
\name{edgep}
\alias{edgep}
\title{Estimating posterior probabilities of single edges}
\usage{
edgep(MCMCchain, pdag = FALSE, burnin = 0.2, endstep = 1)
}
\arguments{
\item{MCMCchain}{an object of class \code{partitionMCMC}, \code{orderMCMC} or \code{iterativeMCMC}, representing the output of structure sampling function \code{\link{partitionMCMC}} or \code{\link{orderMCMC}} (the latter when parameter \code{chainout}=TRUE;}

\item{pdag}{logical, if TRUE (FALSE by default) all DAGs in the MCMCchain are first converted to equivalence class (CPDAG) before the averaging}

\item{burnin}{number between \code{0} and \code{1}, indicates the percentage of the samples which will be discarded as `burn-in' of the MCMC chain; the rest  of the samples will be used to calculate the posterior probabilities; 0.2 by default}

\item{endstep}{number between \code{0} and \code{1}; 1 by default}
}
\value{
a square matrix with dimensions equal to the number of variables; each entry \code{[i,j]} is an estimate of the posterior probability of the edge from node \code{i} to node \code{j}
}
\description{
This function estimates the posterior probabilities of edges by averaging over a sample of DAGs
obtained via an MCMC scheme.
}
\examples{
Bostonscore<-scoreparameters("bge", Boston)
\dontrun{
samplefit<-sampleBN(Bostonscore, "order")
edgesposterior<-edgep(samplefit, pdag=TRUE, burnin=0.2)
}
}
\author{
Polina Suter
}
