% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotusingrgraphviz.R
\name{plotdiffs}
\alias{plotdiffs}
\title{Plotting difference between two graphs}
\usage{
plotdiffs(
  graph1,
  graph2,
  estimated = TRUE,
  name1 = "graph1",
  name2 = "graph2",
  clusters = NULL,
  ...
)
}
\arguments{
\item{graph1}{object of class graphNEL or its adjacency matrix}

\item{graph2}{object of class graphNEL or its adjacency matrix}

\item{estimated}{logical, indicates if graph1 is estimated graph and graph2 is ground truth DAG, TRUE by default; this affects the legend and colouring of the edges}

\item{name1}{character, custom name for 'graph1'}

\item{name2}{character, custom name for 'graph2'}

\item{clusters}{(optional) a list of nodes to be represented on the graph as clusters}

\item{...}{optional parameters passed to \code{Rgraphviz} plotting functions e.g. \code{main}, \code{fontsize}}
}
\value{
plots the graph which includes edges from graph1 and graph2; edges which are different in graph1 compared to graph2 are coloured according to the type of a difference
}
\description{
This function plots edges from two graphs in one and indicates similarities and differences between these graphs.
It is also possible to use this function for plotting mistakes in estimated graph when the ground truth graph is known.
}
\examples{
Asiascore<-scoreparameters("bde",Asia)
Asiamap<-orderMCMC(Asiascore)
plotdiffs(Asiamap$DAG,Asiamat)
Asiacp<-pcalg::dag2cpdag(m2graph(Asiamat))
mapcp<-pcalg::dag2cpdag(m2graph(Asiamap$DAG))
plotdiffs(mapcp,Asiacp)
}
\author{
Polina Suter
}
