% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bidag2coda.R
\name{bidag2coda}
\alias{bidag2coda}
\title{Converting a single BiDAG chain to mcmc object}
\usage{
bidag2coda(
  MCMCtrace,
  edges = FALSE,
  pdag = TRUE,
  p = 0.1,
  burnin = 0.2,
  window = 100,
  cumulative = FALSE
)
}
\arguments{
\item{MCMCtrace}{object of class \code{orderMCMC} or \code{partitionMCMC}}

\item{edges}{logical, when FALSE (default), then only DAG score trace is extracted; when TRUE, a trace of posterior probabilities is extracted for every edge (based on the sampled DAGs defined by parameters 'window' and 'cumulative') resulting in up to n^2 trace vectors, where n is the number of nodes in the network}

\item{pdag}{logical, when edges=TRUE, defines if the DAGs are converted to CPDAGs prior to computing posterior probabilities; ignored otherwise}

\item{p}{numeric, between 0 and 1; defines the minimum probability for including posterior traces in the returned objects (for probabilities close to 0 PRSF diagnostics maybe too conservative)}

\item{burnin}{numeric between \code{0} and \code{1}, indicates the percentage of the samples which will be discarded as 'burn-in' of the MCMC chain; the rest  of the samples will be used to calculate the posterior probabilities; 0.2 by default}

\item{window}{integer, defines a number of DAG samples for averaging and computing edges' posterior probabilities; ignored when edges=FALSE}

\item{cumulative}{logical, indicates if posterior probabilities should be calculated based on a cumulative sample of DAGs, where 25\% of the first samples are discarded}
}
\value{
Object of class \code{mcmc} from the package \pkg{coda}
}
\description{
This function converts a single object of one of the BiDAG classes,
namely 'orderMCMC' or 'partitionMCMC' to an object of class 'mcmc'. This object can
be further used for convergence and mixing diagnostics implemented in the package coda
}
\examples{
\dontrun{
library(coda)
myscore<-scoreparameters("bde",Asia)
ordersample<-sampleBN(myscore,"order")
order_mcmc<-bidag2coda(ordersample)
par(mfrow=c(1,2))
densplot(order_mcmc)
traceplot(order_mcmc)
}
}
\author{
Polina Suter
}
