% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/validation_MRMC_Create_dataList_MRMC_Hit_from_rate_etc.R
\name{replicate_MRMC_dataList}
\alias{replicate_MRMC_dataList}
\title{MRMC: Replicates Datasets From Threshold, Mean and S.D.}
\usage{
replicate_MRMC_dataList(
  replication.number = 2,
  initial.seed = 123,
  mu.truth = BayesianFROC::mu_truth,
  v.truth = BayesianFROC::v_truth,
  z.truth = BayesianFROC::z_truth,
  NI = 200,
  NL = 142,
  ModifiedPoisson = TRUE,
  summary = FALSE
)
}
\arguments{
\item{replication.number}{A positive integer, specifying number of replicated datasets by this function.
For fixed number of lesions, images,
the dataset of hits and false alarms are replicated,
 and the number of replicated datasets are specified by this variable.}

\item{initial.seed}{The variable \code{initial.seed} is used to replicate datasets.
That is, if you take initial.seed = 1234, then the seed 1234, 1235, 1236, 1237, 1238, .... etc are for the first replication, the second replication, the third replication, .... etc.
If the n-th model does not converge for some n,
then such model has no mean and thus the non-convergent models
are omitted to calculate the errors.}

\item{mu.truth}{array of dimension (M,Q).
Mean of the signal distribution
of bi-normal assumption.}

\item{v.truth}{array of dimension (M,Q).
Standard Deviation of represents the signal
 distribution of bi-normal assumption.}

\item{z.truth}{This is a parameter of the
latent Gaussian assumption for the noise distribution.}

\item{NI}{Number of Images.}

\item{NL}{Number of Lesions.}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}.

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per lesion}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pairs of TPF per lesion and FPF  \strong{\emph{per lesion}}.

Similarly,

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per image}},
and model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pair of TPF per lesion and FPF  \strong{\emph{per image}}.



To know details, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.
(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  }, now, it is omiited from this package, because the size of vignettes are large.)

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is defined as follows
 (\eqn{F_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_L}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_L}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_L}, }

  \deqn{ \frac{F_4+F_5}{N_L}, }

   \deqn{ \frac{F_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).
To emphasize its denominator  \eqn{N_L},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per lesion}.


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\emph{False Positive Fraction (FPF)} is given by

\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_I}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_I}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_I}, }

  \deqn{ \frac{F_4+F_5}{N_I}, }

   \deqn{ \frac{F_5}{N_I}, }

where \eqn{N_I} is the number of images (trial).
To emphasize its denominator \eqn{N_I},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per image}.


The model is fitted so that
the estimated FROC curve can be ragraded
 as the expected pairs of   FPF per image and TPF per lesion (\code{ModifiedPoisson = FALSE })

 or as the expected pairs of   FPF per image and TPF per lesion  (\code{ModifiedPoisson = TRUE})

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.
This rigidity of curves means that the number of images is redundant parameter for the FROC trial and
thus the author try to exclude it.


Revised 2019 Dec 8
Revised 2019 Nov 25
Revised 2019 August 28}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary. If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}
}
\value{
A list, each component is also a list, representing an FROC dataset.
}
\description{
Make several datasets from a given  model parameter.
}
\examples{
#----------------------------------------------------------------------------------------
#                Visualization of replicated datasets synthesized by default values
#----------------------------------------------------------------------------------------



#  Replicates datasets from a model with user specified parameters (now, it is default).
         a <-replicate_MRMC_dataList()


# Calculates FPF and TPF and plot it for the first replicatec dataset

         plot_FPF_and_TPF_from_a_dataset(a[[1]])


# Calculates FPF and TPF and plot it for the second replicatec dataset

         plot_FPF_and_TPF_from_a_dataset(a[[2]])



         # Reviesed 2019 Oct 9



}
