% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_MRMC_versionTWO.R
\name{fit_MRMC_versionTWO}
\alias{fit_MRMC_versionTWO}
\title{Fit and Draw the FROC models (curves) version2.}
\usage{
fit_MRMC_versionTWO(dataList, DrawFROCcurve = TRUE, DrawCFPCTP = TRUE,
  version = 2, mesh.for.drawing.curve = 10000,
  significantLevel = 0.7, cha = 1, war = floor(ite/5), ite = 10000,
  dig = 5, see = 1234569)
}
\arguments{
\item{dataList}{This is a variable in the function \code{rstan::sampling()} in which it is named \code{data}.

To make this R object \code{dataList}, this package provide three functions:
please use one of the following codes to obtain an R object representing FROC data:


\describe{
\item{  \code{ \link{convertFromJafroc}()}}{ If  data is a \emph{\strong{JAFROC xlsx}} formulation.}
\item{  \code{ \link{dataset_creator_new_version}()}}{ Enter TP and FP data \emph{\strong{by table}}. }
\item{  \code{ \link{create_dataset}()}}{ Enter TP and FP data by \emph{\strong{interactive}} manner.}
}

This package includes FROC datasets.
Before running the function, we can confirm dataset is correctly formulated by the function \strong{\code{ \link{viewdata}}}.


-------------------------------------------------------------------------------------------------


------------  \strong{Single reader and single modality (SRSC) case.}   --------------


------------------------------------------------------------------------------------------------

In single reader and single modality case (srsc), it should be a list which includes  \code{f, h, NL, NI, C}.
This list contains the following numeric vectors \code{f, h} and numerics \code{NL, NI, C} :
\describe{
\item{ \code{f}  }{Non-negative integer vector  specifying  number of False Alarms   associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{h}  }{Non-negative integer vector  specifying  number  of Hits  associated with  each confidence level. The first component corresponding to the highest confidence level.}
\item{ \code{NL} }{A positive integer, representing  Number of Lesions.}
\item{ \code{NI} }{A positive integer, representing  Number of Images. }
\item{ \code{C}  }{A positive integer, representing  Number of Confidence level. }
}




The detail of these dataset, see the datasets  endowed with this package.
'Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
Note that confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} in the program and do not refer from user input data, where \code{C} is the highest number of confidence levels.
So, you should write down your hits and false alarms vector so that it is compatible with this automatically created \code{c} vector.


\strong{\emph{ Example data:}}

 \emph{            A single reader and single modality case   }

------------------------------------------------------------------------------------------------------
\tabular{rccc}{
\code{NI=63,NL=124}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
 In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
  -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
\emph{\strong{definitely present}}  \tab  5 \tab 1 \tab 41 \cr
 probably present   \tab  4 \tab 2 \tab 22 \cr
 equivocal          \tab  3 \tab 5 \tab 14  \cr
 perhaps present    \tab  2 \tab 11 \tab 8  \cr
 questionable       \tab  1 \tab 13 \tab 1  \cr
 }

---------------------------------------------------------------------------------------------------


*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP

Note that  in FROC data, the confidence level means present (deseased, positive) case only. Since each reader marks their suspicous location only and it generate the hits and false alarms for his confidenc level representing that lesion is present.
In the absent case, reader dose not mark any locations and hence, the absent cofidence level does not relate this dataset.


Note that the first column of confidence level vector \code{c } should not be specified. If specified, will be ignored , since it is created by \code{  c <-c(rep(C:1))} automatically in the program and do not refer from user input data even if it is specified explicitly, where \code{C} is the highest number of confidence levels.
So you should check the compatibility of your data and the program's generating new confidence  level vector by
a table which can be displayed by the function \code{\link{viewdata}()}.


Note that The format for the above example data must be made by the following forms:

\code{ dat <- list(       }

\code{            h = c(41,22,14,8,1),   }

\code{            f = c(1,2,5,11,13),    }

\code{            NL = 124,     }

\code{            NI = 63,    }

\code{            C = 5)         }

And using this object \code{dat}, we can apply \code{fit_Bayesian_FROC()} such as \code{fit_Bayesian_FROC(dat)}.
---------------------------------------------------------------------------------------

  \strong{Multiple readers and multiple modalities case, i.e., MRMC case}


---------------------------------------------------------------------------------------


For  multiple readers and multiple modalities case, i.e., MRMC case,
to apply the function \code{fit_Bayesian_FROC()}, an R list object representing FROC data
must have components \code{m,q,c,h,f,NL,C,M,Q}:
\describe{
\item{ \code{C }  }{A positive integer, representing  the \emph{\strong{highest}} number of confidence level, this is a scalar.}
\item{ \code{M }  }{A positive integer vector, representing  the number of \emph{\strong{modalities}}.  }
\item{ \code{Q }  }{A positive integer, representing  the number of \emph{\strong{readers}}. }
\item{ \code{c }  }{A positive integer vector, representing  the \emph{\strong{confidence level}}. This vector must be made by \code{rep(rep(C:1), M*Q)} }
\item{ \code{m }  }{A positive integer vector, representing  the \emph{\strong{modality}} ID vector. }
\item{ \code{q }  }{A positive integer vector, representing  the \emph{\strong{reader}} ID vector.}
\item{ \code{h }  }{A positive integer vector, representing  the number of \emph{\strong{hits}} vector.}
\item{ \code{f }  }{A positive integer vector, representing  the number of \emph{\strong{false alarm}} vector.}
\item{ \code{NL }  }{A positive integer, representing  the Total number of \emph{\strong{lesions}} for all images, this is a scalar.}
}
The detail of these dataset, please see the example datasets ( the section \strong{See Also} in the below) in this package.



Note that the maximal number of confidence level, denoted by  \code{C}, are included,
however,
its each confidence level vector also created in the program by \code{C}. So, to confirm
your false positives and hits are correctly correspond
to confidence levels,
you should confirm the orders by the function \code{\link{viewdata}()}.


\strong{\emph{ Example data:  }}

 \emph{          Multiple readers and multiple modalities case, i.e., MRMC case   }
---------------------------------------------------------------------------------------------------
\tabular{ccccc}{
 \strong{ ReaderID} \tab   \strong{ModalityID }  \tab  \strong{ Confidence levels} \tab   \strong{No. of false alarms} \tab   \strong{No. of hits}.\cr
  \code{q} \tab  \code{ m}  \tab   \code{c} \tab  \code{ f} \tab \code{ h}\cr
  -------- \tab ------------- \tab ------------------------ \tab  ------------------- \tab ----------------\cr
  1 \tab 1 \tab 5 \tab  1\tab 15\cr
  1 \tab 2 \tab 4  \tab 3\tab 14\cr
  1 \tab 3 \tab 3  \tab 5\tab 5\cr
  1 \tab 1 \tab 2  \tab 5\tab 3\cr
  1 \tab 2 \tab 1  \tab 9\tab 4\cr
  1 \tab 3 \tab 5  \tab 1\tab 14\cr
  1 \tab 1 \tab 4  \tab 2\tab 13\cr
  1 \tab 2 \tab 3  \tab 2\tab 5\cr
  1 \tab 3 \tab 2 \tab 5\tab 3\cr
  2 \tab 1 \tab 1 \tab  6\tab 4\cr
  2 \tab 2 \tab 5  \tab 1\tab 14\cr
  2 \tab 3 \tab 4  \tab 1\tab 4\cr
  2 \tab 1 \tab 3  \tab 1\tab 1\cr
  2 \tab 2 \tab 2  \tab 2\tab 2\cr
  2 \tab 3 \tab 1  \tab 3\tab 2\cr
  2 \tab 1 \tab 5  \tab 1\tab 13\cr
  2 \tab 2 \tab 4 \tab 2\tab 4\cr
  2 \tab 3 \tab 3  \tab 1\tab 2\cr }
---------------------------------------------------------------------------------------------------}

\item{DrawFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether  the FROC curve  is to be drawn.}

\item{DrawCFPCTP}{Logical: \code{TRUE} of \code{FALSE}. Whether  the CFPCTP points are  to be drawn.}

\item{version}{2 or 3}

\item{mesh.for.drawing.curve}{An integer indicating number of dots drawing the curves, default =10000.}

\item{significantLevel}{This is a number between 0 and 1. The results are shown if posterior probabilities are greater than this quantity.}

\item{cha}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{chains}.  A positive integer representing   the number of chains generated by Hamiltonian Monte Carlo method,
and, default = 1.}

\item{war}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{warmup}.  A positive integer representing the Burn in period, which must be less than \code{ite}. Defaults to
war = floor(ite/5)=10000/5=2000,}

\item{ite}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}. A positive integer representing  the  number of samples generated by Hamiltonian Monte Carlo method,
and, default = 10000. If your model could not converge, then raise this number. Must be greater for more reliable estimates.}

\item{dig}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}.   A positive integer representing   the Significant digits, used in stan Cancellation.
default = 5,}

\item{see}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{seed}.  A positive integer representing  seed used in stan,
default = 1234567.}
}
\description{
Fit and Draw the FROC models (curves).
This model is aimed to draw a free-response ROC curves for multiple readers, that is,
resulting FROC curve is one for multiple readers and reflects their hits and false alarms.
}
\examples{
\dontrun{

#================The first example======================================
#(1)First, we prepare the data from this package.

    dat  <- BayesianFROC::dataList.one.modality



#(2)Second, we run fit_Bayesian_FROC() in which the rstan::stan() is implemented.
#with data named "dat"  and the author's Bayesian model.


         fit <-  fit_MRMC_versionTWO(dat,see = 12,ite=2222)

 #      It needs a lot of memory and so, in this example we take the small iteration,
 #      i.e., ite =2222. However if user execute this, then the ite =30000 is recommended
 #      for getting reliable estimates.







#Note that we change the seed from default to 12 to get a convergence model.
#If users enconter the convergence issues,
#then please consider changing the seed like this example.

#The resulting FROC curve means the summarizing curve over all readers

#================The Second example======================================
#(1)First, we prepare the data from this package.

        dat  <- BayesianFROC::dataList.Chakra.Web



#(2)Second, we run fit_Bayesian_FROC() in which the rstan::stan() is implemented.
#with data named "dat"  and the author's Bayesian model.


         fit <-  fit_MRMC_versionTWO(dataList.Chakra.Web ,ite=2222)

#The resulting FROC curve means the summarizing curve over all readers

 #      It needs a lot of memory and so, in this example we take the small iteration,
 #      i.e., ite =2222. However if user execute this, then the ite =30000 is recommended
 #      for getting reliable estimates.







#'#      Close the graphic device to avoid errors in R CMD check.

if (!grDevices::dev.cur()>=2) {

    for (i in 1:grDevices::dev.cur()-1) {message("The",i,"-th graphic device is omitted.")
    grDevices::dev.off()
     }
     }


     }#\dontrun
}
\seealso{
\strong{Example data:}


BayesianFROC::dataList.one.modality

This dataset is a single modality dataset with multiple readers.
}
