% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/p_value_of_the_Bayesian_sense_for_chi_square_goodness_of_fit.R
\name{chi_square_goodness_of_fit}
\alias{chi_square_goodness_of_fit}
\title{The Goodness of Fit (Chi Square) Calculator}
\usage{
chi_square_goodness_of_fit(StanS4class, dig = 3, h, f)
}
\arguments{
\item{StanS4class}{An object of the inherited class of the S4 class stanfit.
That is, the stanfitExtended S4 class defined in this package.}

\item{dig}{An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}.   A positive integer representing   the Significant digits, used in stan Cancellation.
default = 5,}

\item{h}{The number of hits. The reason why we include this variable is to substitute the hits from the posterior predictive distributions.
In famous Gelman's book, he explain how to use the test statistics in the Bayesian context. In this context I need to substitute the replication data from the posterior predictive distributions.}

\item{f}{The number of false alarms. The reason why we include this variable is to substitute the false alarms from the posterior predictive distributions.
In famous Gelman's book, he explain how to use the test statistics in the Bayesian context. In this context I need to substitute the replication data from the posterior predictive distributions.}
}
\value{
Chi squares for each MCMC samples. So, the return values is a vector whose length is number of MCMC iterations minus the warming up period. Of course if MCMC is not only one chain, then taking the summation over all chains.
}
\description{
Chi square goodness of fit statistics for each MCMC sample with a fixed dataset.



   Our data is 2C categories, that is,


 the number of hits        :h[1], h[2], h[3],...,h[C] and

 the number of false alarms: f[1],f[2], f[3],...,f[C].


   Our model has C+2 parameters, that is,

   the thresholds of the bi normal assumption z[1],z[2],z[3],...,z[C] and

   the mean and standard deviation of the signal distribution.


 So, the degree of freedom of this statistics is calculated by


            2C-(C+2)-1 =C -3.

This differ from Chakraborty's  result C-2. Why ?
}
\details{
To calculate the chi square test statistics, the two quantities are needed, that is, data and parameter. In the classical chi square values, as the parameter, for example, MLE(maximal likelihood estimator) is chosen. In Bayesian sense, the parameter can be taken for all MCMC iterations, that is, parameter is not deterministic and we consider it is a random variable or samples from the posterior distribution. And such samples are obtained in the Hamiltonian Monte Carlo Simulation with the author's  Bayesian Model. Thus we can calculate chi square values with MCMC samples.
}
\examples{

\donttest{

#  Get the MCMC samples from a dataset.

       fit <- fit_Bayesian_FROC(BayesianFROC::dataList.Chakra.1,
                           ite = 1111,
                           summary =FALSE,
                           cha = 2)

#   The chi square discrepancies are calculated by the following code

         Chi.Square.for.each.MCMC.samples   <-   chi_square_goodness_of_fit(fit)

#  Get posterior mean of the chi square discrepancy.

                    m<-   mean(Chi.Square.for.each.MCMC.samples)

# Calculate the p-value for the posterior mean of the chi square discrepancy.

                     stats::pchisq(m,df=1)







}# dottest

}
