% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNGP.R
\name{calcQF}
\alias{calcQF}
\title{Calculate the Gaussian quadratic form for the NNGP approximation}
\usage{
calcQF(u, v, AD, nID)
}
\arguments{
\item{u}{Vector; left product.}

\item{v}{Vector; right product}

\item{AD}{N x (k+1) matrix; the first k columns are the 'A' matrix, and the
last column is the 'D' vector. Represents the Cholesky of \code{C^{-1}}.}

\item{nID}{N x k matrix of neighbor indices.}
}
\value{
A list with two components: (1) an N x 2 array containing the 
same spatial coordinates, ordered by MMD, and (2) the same thing, but with 
any NA values removed.
}
\description{
\code{calcQF} calculates the quadratic form in the multivariate Gaussian 
based on the NNGP approximation, for a specific parameter combination. The
quadratic form is \code{t(u)C^{-1}v}.
}
