% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{plot_trace}
\alias{plot_trace}
\title{Plot MCMC trace}
\usage{
plot_trace(
  x_lim,
  samples,
  title = "",
  xlab = "",
  ylab = "",
  color = "black",
  linewidth = 1
)
}
\arguments{
\item{x_lim}{x-axis of the plot}

\item{samples}{samples from MCMC}

\item{title}{optional, add title to plot}

\item{xlab}{optional, add xlabel}

\item{ylab}{optional, add ylabel}

\item{color}{color of the mid line, default is black}

\item{linewidth}{thickness of the plotted line, default is 1}
}
\value{
a ggplot2 object
}
\description{
Creates a trace plot of given MCMC samples.
}
\examples{
data(weibull_cc, package = "BayesFBHborrow")

# Set your initial values and hyper parameters
s <- c(0, quantile(weibull_cc$tte, c(0.5, 1.0), names = FALSE))
initial_param <- list("J" = 1, 
                      "s_r" = s[2], # split points only (length J) 
                      "mu" = 0, 
                      "sigma2" = 2,
                      "lambda" = c(1, 1),
                       "beta" = 0)
               
# run the MCMC sampler CHANGE THIS BEFORE FINAL CHECK
out <- BayesFBHborrow(weibull_cc, NULL, initial_param,
                iter = 10, warmup_iter = 1)

# Create a tarce plot of the treatment effect, beta_1
time_grid <- seq(0, max(s), length.out = 2000)
gg <- plot_trace(1:10, out$out_fixed$beta_1, 
                  title = "Example trace plot",
                  xlab = "iterations", ylab = "beta_1 (treatment effect)")
}
