% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{group_summary}
\alias{group_summary}
\title{Create group level data}
\usage{
group_summary(Y, I, X, s)
}
\arguments{
\item{Y}{data}

\item{I}{censoring indicator}

\item{X}{design matrix}

\item{s}{split points, J + 2}
}
\value{
list of group level data
}
\description{
Aggregate individual level data into group level data
}
\examples{
set.seed(111)
# Load example data and set your initial values and hyper parameters
data(weibull_cc, package = "BayesFBHborrow")
data(weibull_hist, package = "BayesFBHborrow")

Y <- weibull_cc$tte
I <- weibull_cc$event
X <- weibull_cc$X_trt

# Say we want to know the group level data for the following split points
s <- quantile(Y, c(0, 0.45, 0.65, 1), names = FALSE)

group_summary(Y, I, X, s)
}
