% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling_Omega_ij.R
\name{sampling_Omega_ij}
\alias{sampling_Omega_ij}
\title{MCMC sampling of parameter "\eqn{\Omega_{i,j}}" in the \emph{mixdpcluster} model for bayesian clustering.}
\usage{
sampling_Omega_ij(n = 1, Omega.ini, i, j, delta = 4, Z, mu_Z, Lambda,
  sampling_prob, n.burn = 0, n.thin = 0, max.time = Inf, verbose = F,
  USING_CPP = USING_CPP)
}
\arguments{
\item{n}{number of simulations to be generated}

\item{Omega.ini}{matrix \eqn{\Omega} with an initialization value for \eqn{\Omega_{i,j}}.}

\item{i}{indicates the row for \eqn{\Omega_{i,j}}}

\item{j}{indicates the column for \eqn{\Omega_{i,j}}}

\item{delta}{defines the maximum jump on each iteration of the MCMC as \eqn{1/delta} of the feasible interval for \eqn{\Omega_{i,j}}}

\item{Z}{bla}

\item{mu_Z}{bla}

\item{Lambda}{bla}

\item{sampling_prob}{bla}

\item{n.burn}{number of iterations in the simulation considered in the burn-in period.}

\item{n.thin}{number of iterations discarded between two simulated values (for thinning of the MCMC chain).}

\item{max.time}{maximum allowed time for the simulation process. The function returns \code{Error} if exceeded.}

\item{verbose}{if \code{T}, the function reports extra information on progress.}
}
\value{
A list with two elements:
\describe{
  \item{$omega_ij.chain}{A numeric vector with the simulated values from the posterior distribution of \eqn{\Omega_{i,j} }. }
  \item{$accept.indic}{A logical vector indicating whether or not \code{omega_ij.prop} was accepted.}
}
}
\description{
Generates a sample from the the posterior distribution of the \eqn{(i,j)} element of the \eqn{\Omega} matrix in the \emph{mixdpcluster} model for bayesian clustering.
  The simulation is done via Metropolis-Hastings method.
}
\references{
Carmona C., Nieto-Barajas L., Canale A. (2017). \emph{Model based approach for household clustering with mixed scale variables.}
}
\keyword{internal}
