% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_heatmap_bb.R
\name{get_heatmap_bb}
\alias{get_heatmap_bb}
\title{Basketball heatmap}
\usage{
get_heatmap_bb(df_stats, team, levels_stats = NULL, stat_ord, base_size = 9, title)
}
\arguments{
\item{df_stats}{Data frame with the statistics.}

\item{team}{Team.}

\item{levels_stats}{Statistics classified in several categories to plot.
If this is NULL, all the statistics are included in the data frame. Otherwise,
the user can define a vector with the variables to represent.}

\item{stat_ord}{To sort the heatmap on one particular statistic.}

\item{base_size}{Sets the font size in the theme used. Default 9.}

\item{title}{Plot title.}
}
\value{
Graphical device.
}
\description{
The heatmap created with this function allows the user to easily represent
the stats for each player. The more intense the color, the more the player
highlights in the statistic considered. The plot can be ordered by any
statistic. If all the statistics are represented, the offensive statistics are 
grouped in red, the defensive in green, the rest in purple and the advanced in pink.
Otherwise, the default color is red.
}
\examples{
\dontrun{
compet <- "ACB"
df <- do_join_games_bio(compet, acb_games_1718, acb_players_1718)
df1 <- do_add_adv_stats(df)
df2 <- do_stats(df1, "Total", "2017-2018", compet, "Regular Season")
teams <- as.character(rev(sort(unique(df2$Team))))
get_heatmap_bb(df2, teams[6], NULL, "MP", 9, paste(compet, "2017-2018", "Total", sep = " "))
}

}
\author{
This function has been created using the code from these websites:
\url{https://learnr.wordpress.com/2010/01/26/ggplot2-quick-heatmap-plotting/} and 
\url{http://stackoverflow.com/questions/13016022/ggplot2-heatmaps-using-different-gradients-for-categories/13016912}
}
