% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.bas}
\alias{predict.bas}
\alias{predict}
\title{Prediction Method for an object of class BAS}
\usage{
\method{predict}{bas}(object, newdata, se.fit = FALSE, type = "link",
  top = NULL, estimator = "BMA", na.action = na.pass, ...)
}
\arguments{
\item{object}{An object of class BAS, created by \code{bas}}

\item{newdata}{dataframe for predictions. If missing, then use the dataframe
used for fitting for obtaining fitted and predicted values.}

\item{se.fit}{indicator for whether to compute se of fitted and predicted
values}

\item{type}{Type of predictions required. "link" which is on the scale of
the linear predictor is the only option currently for linear models, which for the normal model
is equivalent to type='response'.}

\item{top}{a scalar integer M.  If supplied, subset the top M models, based
on posterior probabilities for model predictions and BMA.}

\item{estimator}{estimator used for predictions.  Currently supported
options include: \cr 'HPM' the highest probability model \cr 'BMA' Bayesian
model averaging, using optionally only the 'top' models \cr 'MPM' the median
probability model of Barbieri and Berger. \cr 'BPM' the model that is
closest to BMA predictions under squared error loss. BMA may be computed
using only the 'top' models if supplied}

\item{na.action}{function determining what should be done with missing values in newdata.
The default is to predict NA.}

\item{...}{optional extra arguments}
}
\value{
a list of
\item{fit}{fitted values based on the selected estimator}
\item{Ybma}{predictions using BMA, the same as fit for non-BMA methods for
compatibilty; will be deprecated}
\item{Ypred}{matrix of predictions under
each model for BMA}
\item{se.fit}{se of fitted values; in the case of BMA
this will be a matrix}
 \item{se.pred}{se for predicted values; in the case
of BMA this will be a matrix}
 \item{se.bma.fit}{vector of posterior sd under
BMA for posterior mean of the regression function.
This will be NULL if estimator is not 'BMA'}
\item{se.bma.pred}{vector of posterior sd under BMA
for posterior predictive values.  this will be NULL if estimator is not
'BMA'}
 \item{best}{index of top models included}
 \item{bestmodels}{subset of
bestmodels used for fitting or prediction}
\item{best.vars}{names of variables in the top model; NULL if estimator='BMA'}
\item{df}{scalar or vector of
degrees of freedom for models}
 \item{estimator}{estimator upon which 'fit'
is based.}
}
\description{
Predictions under model averaging or other estimators from a BMA object of
class inheriting from 'bas'.
}
\details{
Use BMA and/or model selection to form predictions using the top highest
probability models.
}
\examples{

data("Hald")
hald.gprior =  bas.lm(Y ~ ., data=Hald, alpha=13, prior="g-prior")

predict(hald.gprior, newdata=Hald, estimator="BPM", se.fit=TRUE)
# same as fitted
fitted(hald.gprior,estimator="BPM")
# default is BMA and estimation of mean vector
hald.bma = predict(hald.gprior, top=5, se.fit=TRUE)
confint(hald.bma)

hald.bpm = predict(hald.gprior, newdata=Hald[1,],
                    se.fit=TRUE,
                    estimator="BPM")
confint(hald.bpm)
# extract variables
variable.names(hald.bpm)

hald.hpm = predict(hald.gprior, newdata=Hald[1,],
                    se.fit=TRUE,
                    estimator="HPM")
confint(hald.hpm)
variable.names(hald.hpm)

hald.mpm = predict(hald.gprior, newdata=Hald[1,],
                    se.fit=TRUE,
                    estimator="MPM")
confint(hald.mpm)
variable.names(hald.mpm)

}
\seealso{
\code{\link{bas}}, \code{\link{fitted.bas}},
\code{\link{confint.pred.bas}},  \code{\link{variable.names.pred.bas}}

Other predict methods: \code{\link{fitted.bas}},
  \code{\link{predict.basglm}},
  \code{\link{variable.names.pred.bas}}

Other bas methods: \code{\link{BAS}}, \code{\link{bas.lm}},
  \code{\link{coef.bas}}, \code{\link{confint.coef.bas}},
  \code{\link{confint.pred.bas}},
  \code{\link{diagnostics}}, \code{\link{fitted.bas}},
  \code{\link{force.heredity.bas}},
  \code{\link{image.bas}}, \code{\link{predict.basglm}},
  \code{\link{summary.bas}}, \code{\link{update.bas}},
  \code{\link{variable.names.pred.bas}}
}
\author{
Merlise Clyde
}
\concept{bas methods}
\concept{predict methods}
\keyword{regression}
