\name{condstudy_sub}
\alias{condstudy_sub}
\docType{data}
\title{A subset of data for the study of how brand attitudes were influenced by showing brands together with pleasant pictures}
\description{
  This is a subset of the data 'condstudy' with 180 obs.
}
\usage{data(condstudy_sub)}
\format{
  This R object contains a between-subjects variable: type, which denotes a between-subject moderator. It has two levels, "indirect" and "direct". In the "indirect" condition the brands were shown with the same images, in the indirect condition the brands were shown with different images; Within-subject variables: cond, a within-subject factor with 2 levels: "pos", and "xneu", which indicates whether each brand was shown with a neutral (xneu) or positive (pos) emotional image. pict,  a within-subject mediator variable measuring the valence (positive/negative) of the emotional image the respondent remembers the brand to have been shown with. att, a dependent variable which denotes the ratings of attitudes toward brands. 

 
 \$ condstudy_sub: 'data.frame':  180 obs. of  5 variables:\cr
 \ldots\$ id  : int  2 2 2 2 2 2 3 3 3 3 ... \cr
 \ldots\$ att : num  2.94 2.44 3.44 1.67 1.67 ... \cr
 \ldots\$ cond: Factor w/ 2 levels "pos","xneu": 1 1 1 2 2 2 1 1 1 2 ... \cr
 \ldots\$ type: Factor w/ 2 levels "direct","indirect": 2 2 2 2 2 2 2 2 2 2 ... \cr
 \ldots\$ pict: int  6 7 6 2 4 5 9 3 2 5 ... \cr
 
}

\examples{
\donttest{
# condstudy_sub is a subset of condstudy with 180 obs. and the same variables
data(condstudy_sub)
library(rstan)
model <- BANOVA.model('Normal')
stanmodel <- BANOVA.build(model)
out2 <- BANOVA.run(att~cond+pict, ~type, fit = stanmodel, data = condstudy_sub, 
                  id = 'id', iter = 500, thin = 1, chains = 2)    
conv.diag(out2)
summary(out2) 
table.predictions(out2)  
BANOVA.floodlight(out2, var_factor = 'type', var_numeric = 'pict')
cat(out2$model_code)

out3 <- BANOVA.run(pict~cond, ~type, fit = stanmodel, data = condstudy_sub, 
                  id = 'id', iter = 500, thin = 1, chains = 2)
conv.diag(out3)
summary(out3)
BANOVA.mediation(out2, out3, xvar='cond', mediator='pict')
}
}